# ----------------------------------------------------------------------------
#       Copyright (C) 2013-2014 Huynh Vi Lam  <domovilam@gmail.com>
#
#       This file is part of pimucha.
#
#	This program is free software: you can redistribute it and/or modify
#	it under the terms of the GNU General Public License as published by
#	the Free Software Foundation, either version 3 of the License, or
#	(at your option) any later version.
#	
#	This program is distributed in the hope that it will be useful,
#	but WITHOUT ANY WARRANTY; without even the implied warranty of
#	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#	GNU General Public License for more details.
#	
#	You should have received a copy of the GNU General Public License
#	along with this program.  If not, see <http://www.gnu.org/licenses/>.
# ----------------------------------------------------------------------------

import logging,sys,threading,time

from piHAlibs import (confgetval)
from .corelibs import (
    actionscriptexe,lst2lines,
    enable,disable,chgunit,addunit,addalias,
    )
from .servers import (INPUTq)
from .rpccmds import (RPCFunctions)

logger = logging.getLogger()


def actionscript(script):
    pscript = confgetval('pimucha.conf','FilesPath','ACTIONScript','actionscript/')
    thefile = pscript + script.lower() + '.scr'
    lines = lst2lines(thefile)
    if not lines:
        return False
    logger.debug('Executing %s...', thefile)
    p = threading.Thread(target=actionscriptexe, args=(lines,UserCmds))
    p.__name__ = 'ThreadACTIONScript_' + 'script'
    p.daemon = True
    p.start()
    return True
RPCFunctions.append((actionscript,'script'))


UserCmds = {
    'ADDALIAS' : addalias,
    'ADDUNIT' : addunit,
    'CHGUNIT' : chgunit,
    'ENABLE' : enable,
    'DISABLE' : disable,
    'INPUT' : INPUTq.put_nowait,
    }
