# ----------------------------------------------------------------------------
#       Copyright (C) 2013-2014 Huynh Vi Lam  <domovilam@gmail.com>
#
#       This file is part of pimucha.
#
#	This program is free software: you can redistribute it and/or modify
#	it under the terms of the GNU General Public License as published by
#	the Free Software Foundation, either version 3 of the License, or
#	(at your option) any later version.
#	
#	This program is distributed in the hope that it will be useful,
#	but WITHOUT ANY WARRANTY; without even the implied warranty of
#	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#	GNU General Public License for more details.
#	
#	You should have received a copy of the GNU General Public License
#	along with this program.  If not, see <http://www.gnu.org/licenses/>.
# ----------------------------------------------------------------------------

import logging,sys,threading
from piHAlibs import (my_fctname,coroutine,db2dict,header,unitid)
from .x10libs import *

logger = logging.getLogger()
		

def cancelx10timer(name):
    ths = threading.enumerate()
    for th in ths:
        if name in repr(th):
            th.cancel()

def flushx10evt(targets,hq):
    """
    Timer (delay 15s) use to flush the partial previous event
    by sending to cm11decode an event one byte long
    """
    if not hq.empty():
        evt = hq.get_nowait()
        for target in targets: target.send(evt)

@my_fctname
@coroutine	
def x10plcdecoder(targets,rejected=None,newids=None,rawevt=None):
    """
    Decode an X10 complete event receiving from CM11a over Powerline
	Only for event with ON / OFF function
	item = ['CM0:CM11','0x02 0x00 0x68 0x02 0x01 0x62'] (X10 cmd = A14 ON)
        msgs = ['CM0:CM11', 'x10', ['0x02', '0x00', '0x68', '0x02', '0x01', '0x62'], [2, 0, 104, 2, 1, 98], 'NC','0x5a','0x02 0x00 0x68 0x02 0x01 0x62']
    """
    condition = " WHERE typeunit = 'device'"
    ids = db2dict('UNITIDS',condition)
    while True:
        msgs = (yield)
        logger.debug("Msgs received %s",repr(msgs))
        # msgs = [namedev, protocol, data, packet, model]
        namedev, protocol, data, p, model,hd,revt = msgs
        if hd != '0x5a': continue
       	if len(data) != 6: continue
       	logger.debug("Check for x10 PL with these values %s",repr(p))
        try:				#Decode house + unit
            hu = hex2hu(data[2])	#A14
        except:
            logger.error('Error in decoding %s',repr(data))
       	    if rejected: rejected.send(['FAIL_DECODE_huf'] + msgs)
       	    continue
        hfb = x10decode1(data[3:])	#Decode house + function
        if hfb:
            hf,b,f = hfb		#[['A', 'ON'], 'ON', 2]
        else:
            logger.debug("Function x10plcdecoder unable to decode %s",repr(data))
       	    if rejected: rejected.send(['FAIL_DECODE_huf'] + msgs)
            continue
        if hu[0] != hf[0]:
            logger.info( "House code of data : %s is different with %s", hu[0], hf[0])
       	    if rejected: rejected.send(['DIFF_DECODE_huf'] + msgs)
       	    continue
        decevt = [protocol,hu,b]
        event = header(namedev) + ['DEVICE'] + decevt
        for target in targets:
            logger.debug("Function x10plcdecoder for %s",repr(event))
            target.send(event)
        #Receiver Unit / addr
        if (protocol, hu) not in ids:
            logger.debug("New device X10 detected with unit %s", hu)
            if newids: ids = unitid([protocol,model,'device',hu])
        if rawevt: rawevt.send([namedev,revt,' '.join(decevt)])


@my_fctname
@coroutine	
def x10pldecoder(targets,rejected=None,newids=None,rawevt=None):
    """
    Decode an X10 partial event receiving from CM11a or CM15a over Powerline
    """
    if sys.hexversion < 0x030000F0:
        import Queue
        hq = Queue.Queue()
    else:
        import queue
        hq = queue.Queue()
    condition = " WHERE typeunit = 'device'"
    ids = db2dict('UNITIDS',condition)
    while True:
        msgs = (yield)
       	logger.debug("Msgs received %s",repr(msgs))
        namedev, protocol, data, p, model,hd,revt = msgs
        if hd != '0x5a': continue
        dev = namedev.split(':')[1]
        if hq.empty():
            hu = None					#House + Unit
            event = []
        nb = len(data)
        if nb > 4: continue
        if nb == p[0] + 1:
            if p[1] == 0:			#Evt with house + unit
                try:
                    a = hex2hu(data[2])
                except:
                    logger.error('Error in decoding %s',repr(data))
                    if rejected: rejected.send(['FAIL_DECODE_huf'] + msgs)
                    continue
                if hu != a:
                    if not hq.empty():
                        for target in targets:
                            target.send(hq.get_nowait())
                hu = a
                try:
                    hq.put_nowait(header(namedev) + [protocol] + [hu,'NA',1])	#Put the new evt in the queue
                except:
                    pass
                d = threading.Timer(3,flushx10evt,[targets,hq,])
                d.name = 'Timer_x10pldecoder_' + hu.lower()
                d.start()
            elif p[1] == 1:
                hfb = x10decode1(data)
                if hfb:
                    hf,b,f = hfb
                else:
                    logger.debug("Unable to decode %s",repr(data))
                    if rejected: rejected.send(['FAIL_DECODE_huf'] + msgs)
                    continue
                if not hu:
                    a = hf[0]
                else:
                    if hu[0] != hf[0]:
                        logger.info( "House code of previous event : %s is different with %s", hu[0], hf[0])
                        logger.info( "Event X10 : %s", repr(data))
                        continue
                    a = hu
                decevt = [protocol,a,b]
                event = header(namedev) + ['DEVICE'] + decevt
                for target in targets:
                   logger.debug("Function x10pldecoder for %s",repr(event))
                   target.send(event)
                #Receiver Unit / addr
                if (protocol, a) not in ids:
                    logger.debug("New device X10 detected with unit %s", a)
                    if newids: ids = unitid([protocol,model,'device',hu])
                if rawevt: rawevt.send([namedev,revt,' '.join(decevt)])
                #Cancel Timer
                if a:
                    if not hq.empty():
                        hq.get_nowait()
                    cancelx10timer('Timer_x10pldecoder')
            elif p[1] == 2:			#house + unit  - house + function
                huhf = x10decode2(dev,data)
                if huhf:
                    if huhf[0]:
                        hu = huhf[0]
                    hf = huhf[1]
                else:
                    logger.debug("Unable to decoded %s",repr(data))
                    if rejected: rejected.send(['FAIL_DECODE_huf'] + msgs)
                    continue
                decevt = [protocol,hu,hf[1]]
                event = header(namedev) + ['DEVICE'] + decevt
                logger.debug("Function x10pldecoder for %s",repr(event))
                for target in targets: target.send(event)
                if (protocol, hu) not in ids:
                    logger.debug("New device X10 detected with unit %s", hu)
                    if newids: ids = unitid([protocol,model,'device',hu])
                if rawevt: rawevt.send([namedev,revt,' '.join(decevt)])
                if hu:
                    if not hq.empty():
                        hq.get_nowait()			#Empty the queue
                    cancelx10timer('Timer_x10pldecoder')
        else:
            logger.warning('First value read %s for the sequence differs with the length %s of incoming event',data[0],nb)
       	    if rejected: rejected.send(['DIFF_DECODE_huf'] + msgs)
