from piHAlibs import (debug,log2console,log2file,printer)
from .testslibs import (linesend,lineaddname,lst2lines,main2,main3)
import logging,sys
logger = logging.getLogger()


if sys.hexversion < 0x020700F0:
    args = main2()
else:
    args = main3()

print ("Command line arguments : %s" % repr(args))
EVTS = []
TARGETS = [printer(),]

if args['evtfile'] is None:
    print ("Error, a file name is needed...")
    sys.exit()
else:
    EVTS = lst2lines(args['evtfile'])
    if (EVTS is None) or (EVTS == []):
        sys.exit()

if args['debug']:
    log2console()
    logger.setLevel(logging.DEBUG)
    TARGETS.append(debug())

if args['output']:
    try:
        wf = open(args['output'],'ab')
        wf.close()
    except Exception as e:
        logger.error("%s : %s", repr(e.__class__), str(e))
        sys.exit()
    TARGETS.append(log2file(args['output']))

if args['controller'] == 'atir':
    from piHAparsers.patir import ATIRparser
    from piHAparsers.rxdevices import devdecoder
    from piHAparsers.rxremotes import rxremote
    linesend(EVTS,lineaddname('ATI0:ATIR',ATIRparser([
        devdecoder(TARGETS,printer(),newids=True),
        rxremote(TARGETS,printer(),newids=True),
       	],printer())))

if args['controller'] == 'cm11':
    from piHAparsers.pcm11 import CM11parser
    from piHAparsers.pldevices import (x10pldecoder,x10plcdecoder)
    linesend(EVTS,lineaddname('CM0:CM11',CM11parser([
        x10pldecoder(TARGETS,printer(),newids=True),
        x10plcdecoder(TARGETS,printer(),newids=True),
       	],printer())))

if args['controller'] == 'cm15':
    from piHAparsers.pcm15 import CM15parser
    from piHAparsers.pldevices import (x10pldecoder,x10plcdecoder)
    from piHAparsers.rxdetectors import detdecoder
    from piHAparsers.rxdevices import devdecoder
    from piHAparsers.rxremotes import rxremote
    linesend(EVTS,lineaddname('CM0:CM15',CM15parser([
        detdecoder(TARGETS,printer(),newids=True),
        devdecoder(TARGETS,printer(),newids=True),
        rxremote(TARGETS,printer(),newids=True),
        x10pldecoder(TARGETS,printer(),newids=True),
        x10plcdecoder(TARGETS,printer(),newids=True),
       	],printer())))

if args['controller'] == 'rfxcom':
    from piHAparsers.prfxcom import RFXCOMparser
    from piHAparsers.rxdetectors import detdecoder
    from piHAparsers.rxdevices import devdecoder
    from piHAparsers.rxremotes import rxremote
    from piHAparsers.rxsensors import oredecoder
    linesend(EVTS,lineaddname('RFX0:RFXCOM',RFXCOMparser([
        devdecoder(TARGETS,printer(),newids=True),
        oredecoder(TARGETS,printer(),newids=True),
        rxremote(TARGETS,printer(),newids=True),
        detdecoder(TARGETS,printer(),newids=True),
       	],printer())))

if args['controller'] == 'tsduo':
    from piHAparsers.ptsduo import TSDUOparser
    from piHAparsers.rxdevices import devdecoder
    from piHAparsers.rxsensors import oredecoder
    linesend(EVTS,lineaddname('TSD0:TSDUO',TSDUOparser([
        devdecoder(TARGETS,printer(),newids=True),
        oredecoder(TARGETS,printer(),newids=True),
       	],printer())))

if args['controller'] == 'rfxtrx':
    try:
        from piHAparsers.prfxtrx import RFXTRXparser
        from piHAparsers.trxdetectors import tdetdecoder
        from piHAparsers.trxdevices import tdevdecoder
        from piHAparsers.trxsensors import sensordecoder
    except:
        print ('RFXtrx modules not yet installed')
        sys.exit()
    linesend(EVTS,lineaddname('TRX0:RFXTRX',RFXTRXparser([
        tdetdecoder(TARGETS,printer(),newids=True),
        tdevdecoder(TARGETS,printer(),newids=True),
        sensordecoder(TARGETS,printer(),newids=True),
       	],printer())))


