# ----------------------------------------------------------------------------
#       Copyright (C) 2013-2014 Huynh Vi Lam  <domovilam@gmail.com>
#
#       This file is part of pimucha.
#
#	This program is free software: you can redistribute it and/or modify
#	it under the terms of the GNU General Public License as published by
#	the Free Software Foundation, either version 3 of the License, or
#	(at your option) any later version.
#	
#	This program is distributed in the hope that it will be useful,
#	but WITHOUT ANY WARRANTY; without even the implied warranty of
#	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#	GNU General Public License for more details.
#	
#	You should have received a copy of the GNU General Public License
#	along with this program.  If not, see <http://www.gnu.org/licenses/>.
# ----------------------------------------------------------------------------

import datetime
from piHAparsers.x10libs import (checkhu)
from piHAlibs import (
    dumprows,majdb3,ralldb3,reqdb3,
    newalias,
)


def addalias(data):
    """
    item = [typeunit,unit,alias]
    typeunit = ['detector','device','sensor']
    unit = houseunit
    alias = name of the unit
    """
    if isinstance(data,list):
        item = data
    else:
        item = data.split()
    tu = ['detector','device','sensor']
    if item[0] not in tu: return 'First parameter must be in the list %s' % repr(tu)
    if not checkhu(item[1]): return 'Syntax error for houseunit code %s' % repr(item[2])
    alias = '_'.join(item[2:])
    hu = item[1].upper()
    return newalias([item[0], item[1].upper(), alias])


def aliashu(a):
    req = 'SELECT unit FROM alias WHERE label = ?;'
    r = reqdb3(req,[a,])
    if r:
        return r[0]
    else:
        return None


def alias2hu(item):
    hu = aliashu(item)
    return hu


def hualias(a):
    req = "SELECT label FROM alias WHERE unit = ?;"
    r = reqdb3(req,[a.upper(),])
    if r:
        return r[0]
    else:
        return None


def hudevice(a):
    req = "SELECT unitId FROM unitIds WHERE typeunit = 'device' AND unit = ?;"
    r = reqdb3(req,[a,])
    id = None
    if r: id = r[0]
    req = "SELECT idencoder FROM alias WHERE typeunit = 'device' AND unit = ?;"
    r = reqdb3(req,[a,])
    enc = None
    if r:
        if r[0] != '': enc = r[0]
    return id,enc


def huencoder(data):
    """
    item = [typeunit, unit, encoder]
    """
    if isinstance(data,list):
        item = data
    else:
        item = data.split()
    req = "SELECT rowId FROM alias WHERE typeunit = ? AND unit = ?;"
    r = reqdb3(req,[item[0],item[1]])
    if not r: return False
    req = "update alias SET idencoder = ?  WHERE typeunit = ? AND unit = ?;"
    r = majdb3(req,[item[2],item[0],item[1]])
    return True


def huoralias(item):
    alias = hualias(item)
    if alias:
        return item
    hu = aliashu(item)
    return hu
 

def huorhexid(item):
    if item.startswith('0x'):
        return item.lower()	#hexid : => lower
    if checkhu(item):	#houseunit : => upper
        return item.upper()
    return None


def hu2alias(item):
    hu = item.upper()
    alias = hualias(hu)
    if alias:
        return alias
    else:
        return 'NoAlias'
