# ----------------------------------------------------------------------------
#       Copyright (C) 2013-2014 Huynh Vi Lam  <domovilam@gmail.com>
#
#       This file is part of pimucha.
#
#	This program is free software: you can redistribute it and/or modify
#	it under the terms of the GNU General Public License as published by
#	the Free Software Foundation, either version 3 of the License, or
#	(at your option) any later version.
#	
#	This program is distributed in the hope that it will be useful,
#	but WITHOUT ANY WARRANTY; without even the implied warranty of
#	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#	GNU General Public License for more details.
#	
#	You should have received a copy of the GNU General Public License
#	along with this program.  If not, see <http://www.gnu.org/licenses/>.
# ----------------------------------------------------------------------------

import datetime,logging
from piHAparsers.x10libs import (checkhu)
from piHAlibs import (
    dumprows,majdb3,ralldb3,reqdb3,
    newalias,newhu,
)

logger = logging.getLogger()


def addunit(data):
    """
    item = [typeunit,unitid,hu,alias]
    typeunit = ['detector','device']
    unitid = addrid (hex form) or hu (houseunit)
    alias = name / label of the unit
    """
    if isinstance(data,list):
        item = data
    else:
        item = data.split()
    if len(item) < 3: return 'Minimum of three parameters needed'
    if not checkhu(item[2]): return 'Syntax error for houseunit code %s' % repr(item[2])
    if len(item) == 3:
        alias = item[0] + '_' + item[2]
    else:
        alias = item[3:]
    alias = alias.replace(' ','_')
    d = datetime.date.strftime(datetime.datetime.today(),"%Y-%m-%d %H:%M:%S").split()
    if item[0] in ['detector','device']:
        req = "INSERT INTO unitIds(cdate,ctime,typeunit,unitId,unit,label) VALUES (?,?,?,?,?,?);"
    else:
        return 'Type unit incorrect for this function'
    V = [d[0], d[1], item[0], item[1],item[2], alias]
    majdb3(req,V)
    try:
        newalias([item[0], item[2], alias])
    except Exception as e:
        logger.debug("Update failed for newids with error : %s",repr(e))
    return 'Unit %s added successfully' % item[1]


def chgunit(data):
    """
    Affect to an new unitid an existing hu (and alias)
    Remove the new hu (and alias)
    item = [typeunit,unitid,oldhu,(alias)]
    typeunit = ['detector','device','sensor']
    new unitid (addrid hex form or houseunit) must exist : nhu
    if alias not provided, oldhu must exist (alias exists also)
    if alias provided, add alias and hu
    """
    if isinstance(data,list):
        item = data
    else:
        item = data.split()
    if len(item) < 3: return 'Minimun three parameters needed'
    if item[0] not in ['detector','device','sensor']: return 'Type unit incorrect for this function'
    if not checkhu(item[2]): return 'Syntax error for houseunit code %s' % repr(item[2])
    #Check new unitId
    req = "SELECT unit FROM unitIds WHERE typeunit = ? AND unitId = ?  ;"
    V = item[0:2]
    r = reqdb3(req,V)
    if r is None:
        return 'UnitId %s must exist in DB' % item[1]
    else:
        nhu = r[0]
    if nhu == item[2]: return 'No change made, unitId and hu represent the same unit'
    #Check oldhu, if alias not provided
    if len(item) == 3:
        req = "SELECT label FROM alias WHERE unit = ?;"
        V = [item[2],]
        alias = reqdb3(req,V)
        if alias is None: return 'HouseUnit %s (and alias) must exist in DB' % item[2]
        #Remove newhu
        req = "DELETE FROM alias WHERE unit = ?;"
        V = [nhu,]
        majdb3(req,V)
    else:
        #Add alias and hu provided
        alias = item[3:]
        alias = alias.replace(' ','_')
        newalias([item[0], item[2], alias])
    #Change with existing oldhu or hu provided
    req = "UPDATE unitIds SET unit = ? WHERE typeunit = ? AND unitId = ?;"
    V = [item[2],item[0],item[1]]
    majdb3(req,V)
    #Additional change if sensor
    if item[0] == 'sensor':
        #Remove parameterIds rows of old unit hu
        req = "DELETE FROM parameterIds WHERE unit = ?;"
        V = [item[2],]
        majdb3(req,V)
        #Update parameterIds rows of new unitId with old hu
        req = "UPDATE parameterIds SET unit = ? WHERE modaddrId = ?;"
        V = [item[2],item[1]]
        majdb3(req,V)
    return 'Changes successful for %s' % data


def lsunit(param,rowids=None):
    param = param.lower()
    if param not in ['alias','detector','device','parameter','sensor']: param = 'alias'
    req = "SELECT d.rowId,"
    if param == 'alias':
        req +=  "unit,label,typeunit,enabled FROM alias as d "
        if rowids: req += " WHERE d.rowId IN (" + rowids + ")"
    elif param in ('detector','device','sensor'):
        req +=  "modelId,iddecoder,unitId,d.unit,d.enabled,a.label "
        req +=  " FROM unitIds as d, alias as a WHERE d.unit = a.unit "
        req +=  " AND d.typeunit = a.typeunit "
        req +=  " AND d.typeunit = '" + param.lower() + "' "
        if rowids: req += " AND d.rowId IN (" + rowids + ")"
    elif param == 'parameter':
        req +=  "modaddrId,parameter,d.unit,updatedmaxt,d.enabled,a.label "
        req +=  "FROM parameterIds as d, alias as a WHERE d.unit = a.unit "
        req +=  " AND a.typeunit = 'sensor' "
        if rowids: req += " AND d.rowId IN (" + rowids + ")"
    rows = ralldb3(req,())
    if not rows : return 'No rows of ' + param + ' in DB'
    return '\n'.join(dumprows(rows))


def enable(data):
    return updunit('True',data)


def disable(data):
    return updunit('False',data)


def updunit(truefalse,data):
    """
    Update field enabled to 'True' or 'False'
    for table parameterIds, unitIds
    item = [truefalse,type,list of rowids]
    truefalse = 'True' or 'False'
    type = ['alias','detector','device','parameter','sensor']
    """
    if isinstance(data,list):
        item = data
    else:
        item = data.split()
    type = ['alias','detector','device','parameter','sensor']
    if item[0] not in type:
        return 'First parameter must be in the list %s' % repr(type)
    if len(item) < 2:
        return 'Syntax error, minimum of one Id needed after first parameter'
    #Check that rowid is integer
    for i in item[1:]:
        if not i.isdigit(): return 'Syntax error, this parameter %s must be an integer' % repr(i)
    rowids = ','.join(item[1:])
    req = "UPDATE "
    if item[0] == 'alias':
        req += " alias "
    elif item[0] in ('detector','device','sensor'):
        req += " unitids "
    elif item[0] == 'parameter':
        req += " parameterids "
    req += " SET enabled = ? WHERE rowId IN (" + rowids + ")"
    try:
        nb = majdb3(req,(truefalse,))
    except Exception as e:
        return 'Error update :%s' % repr(e)
    if nb > 0:
        res = lsunit(item[0],rowids)
        return '\tUpdate successful for %s rows \n%s ' % (nb,res)
    else:
        return 'No update made with %s' % repr (data)
