import logging,sys
logger = logging.getLogger()
from piHAlibs import (log2console)
from piHAparsers import (cmdcheck,cmdencode)
from .testslibs import (main2e,main3e)


if sys.hexversion < 0x020700F0:
    args = main2e()
else:
    args = main3e()
print ("Command line arguments : %s" % repr(args))


if args['debug']:
    log2console()
    logger.setLevel(logging.DEBUG)

if args['listprotocol']:
    from piHAparsers.cmdcontrollers import (FORDevices,WITHControllers)
    print ('List of supported protocol for encoding :')
    for i in FORDevices:
        print ('Protocol: %s\n With controllers: %s\n For devices: %s' % (repr(i),WITHControllers[i],FORDevices[i]))
    sys.exit()


check = cmdcheck([args['protocol'].upper(),args['houseunit'],args['function']])
if not check:
    print ('Failed to check HU FCT for input data %s' % repr(args))
    sys.exit()
else:
    print ('Sucess of checking Input : %s ' % repr(check))
cmd = cmdencode(check)
if not cmd:
    print ('Failed to encode command with %s' % repr(check))
else:
    print ('Encoded command : %s' % repr(cmd[2]))
    print ('To send to controllers : %s' % repr(cmd[0]))
