# ----------------------------------------------------------------------------
#       Copyright (C) 2013-2014 Huynh Vi Lam  <domovilam@gmail.com>
#
#       This file is part of pimucha.
#
#	This program is free software: you can redistribute it and/or modify
#	it under the terms of the GNU General Public License as published by
#	the Free Software Foundation, either version 3 of the License, or
#	(at your option) any later version.
#	
#	This program is distributed in the hope that it will be useful,
#	but WITHOUT ANY WARRANTY; without even the implied warranty of
#	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#	GNU General Public License for more details.
#	
#	You should have received a copy of the GNU General Public License
#	along with this program.  If not, see <http://www.gnu.org/licenses/>.
# ----------------------------------------------------------------------------

import logging,sys
logger = logging.getLogger()

ATIRParsers = {
    ('0x14', '0x14'): ('ati', 'rxremote'),
    ('0x20', '0x20'): ('x10', 'devdecoder detdecoder rxremote'),
    }

CM15Parsers = {
    ('0x5d','0x14'):('ati','rxremote'),
    ('0x5d','0x20'):('x10','devdecoder detdecoder rxremote'),
    ('0x5d','0x29'):('x10s','devdecoder detdecoder rxremote'),
    }

RFXCOMParsers = {
    ('0x14','0x14'):('ati','rxremote'),
    ('0x20','0x20'):('x10','devdecoder detdecoder rxremote'),
    ('0x29','0x29'):('x10s','devdecoder detdecoder rxremote'),
    ('0x22','0x22'):('arctech','devdecoder detdecoder rxremote'),
    ('0x50','0x1a2d'):('oregon','oredecoder'),
    ('0x50','0xfa28'):('oregon','oredecoder'),
    ('0x5c','0x2a19'):('oregon','oredecoder'),
    ('0x6c','0x2a'):('oregon','oredecoder'),
    ('0x58','0x1a89'):('oregon','oredecoder'),
    ('0x44','0xea4c'):('oregon','oredecoder'),
    ('0x44','0x1a2d'):('oregon','oredecoder'),
    ('0x6c','0x62'):('oregon','oredecoder'),
    ('0x4c','0x1a2d'):('oregon','oredecoder'),
    ('0x40','0x1a2d'):('oregon','oredecoder'),
    ('0x78','0x78ea'):('oregon','oredecoder'),
    ('0x38','0x38'):('oregon','oredecoder'),
    ('0x40','0x40'):('oregon','oredecoder'),
    ('0x44','0xca48'):('oregon','oredecoder'),
    ('0x58','0xea4c'):('oregon','oredecoder'),
    ('0x50','0x0acc'):('oregon','oredecoder'),
    ('0x50','0xca2c'):('oregon','oredecoder'),
    ('0x50','0x1a3d'):('oregon','oredecoder'),
    ('0x58','0x5a5d'):('oregon','oredecoder'),
    ('0x60','0x5a6d'):('oregon','oredecoder'),
    ('0x58','0x1a99'):('oregon','oredecoder'),
    ('0x60','0x3a0d'):('oregon','oredecoder'),
    ('0x78','0xea7c'):('oregon','oredecoder'),
    ('0x48','0xda78'):('oregon','oredecoder'),
    ('0x54','0x2a1d'):('oregon','oredecoder'),
    ('0x5c','0x06e4'):('oregon','oredecoder'),
    ('0x3c','0x1a2d'):('oregon','oredecoder'),
    ('0x48','0x1a2d'):('oregon','oredecoder'),
    ('0x38','0x1a2d'):('oregon','oredecoder'),
    ('0x58','0x2a19'):('oregon','oredecoder'),
    ('0x78','0x1a2d'):('oregon','oredecoder'),
    ('0x4c','0x2a19'):('oregon','oredecoder'),
    ('0x48','0x2a19'):('oregon','oredecoder'),
    ('0x54','0x2a19'):('oregon','oredecoder'),
    ('0x3c','0x2a19'):('oregon','oredecoder'),
    ('0x50','0x2a19'):('oregon','oredecoder'),
    ('0x48','0xea4c'):('oregon','oredecoder'),
    }

TSDUOParsers = {
    ('arctech','selflearning'):('devdecoder detdecoder rxremote','0x22'),
    ('x10','NC'):('devdecoder detdecoder rxremote','0x20'),
    ('oregon','0xea4c'):('oredecoder','0x44'),
    ('everflourish','NC'):('devdecoder detdecoder rxremote','0x22'),
    }

DETDECODERS = {
    ('0x20','x10') : ('chkx10rf(p)', '', 'cvh2x10rf(p)') ,
    ('0x22','arctech') : ('','','archuf(p)') ,
    ('0x29','x10s') : ('chkssec1(p)', 'chkssec2(p)', 'evalhuf1(data)') ,
    }

DEVDECODERS = {
    ('0x20','x10') : ('chkx10rf(p)','cvh2x10rf(p)') ,
    ('0x22','arctech') : ('','archuf(p)') ,
    }

REMDECODERS = {
    ('0x14','ati') : ('','','atirmap(p)') ,
    ('0x20','x10r') : ('chksrfr(p)','','pcrmap(p)') ,
    ('0x20','x10') : ('chkx10rf(p)','','cvh2x10rf(p)') ,
    ('0x22','arctech') : ('','','archuf(p)') ,
    ('0x29','x10s') : ('chkssec1(p)', 'chkssec2(p)', 'evalhuf1(data)') ,
    }

OREDECODERS = {
    ('0x5c', '0x2a19') : ('', 'chks8(p)', 3, 'Channel Battery oreRainRate oreRainTot', '[chanm0(p),battm1(p),rainrate(p),raintotal(p)]') ,
    ('0x40', '0x40') : ('chksidg(p)', '', 1, 'Channel Weight', '[chanm0(p),weight1(p)]') ,
    ('0x4c', '0x1a2d') : ('', '', 3, 'Channel Battery oreTemp', '[chanm1(p),battm1(p),temp(p)]') ,
    ('0x50', '0x0acc') : ('', 'chks2(p)', 3, 'Channel Battery oreTemp oreRH', '[chanm2(p),battm1(p),temp(p),hum(p)]') ,
    ('0x48', '0xda78') : ('', 'chks7(p)', 3, 'Battery oreUV', '[battm1(p),uvn(p)]') ,
    ('0x6c', '0x2a') : ('chksido(p)', 'chkso(p)', 2, 'Channel Counter owlPower owlEnergy', '[chanmo(p),count(p),pow(p),energy(p)]') ,
    ('0x58', '0xea4c') : ('', 'chks1(p)', 3, 'Channel Battery oreTemp', '[chanm1(p),battm1(p),temp(p)]') ,
    ('0x6c', '0x62') : ('', '', 2, 'Channel Counter owlPower owlEnergy', '[chanmo(p),count(p),pow(p),energy(p)]') ,
    ('0x3c', '0x1a2d') : ('', '', 3, 'Channel Battery oreTemp', '[chanm1(p),battm1(p),temp(p)]') ,
    ('0x50', '0xfa28') : ('', 'chks2(p)', 3, 'Channel Battery oreTemp oreRH', '[chanm2(p),battm1(p),temp(p),hum(p)]') ,
    ('0x58', '0x1a99') : ('', 'chks4(p)', 3, 'Channel Battery oreWindDir oreWindSp oreWindAvSp', '[chanm0(p),battm1(p),wdirno(p),wspeed(p),wspeedavg(p)]') ,
    ('0x58', '0x2a19') : ('', 'chks8(p)', 3, 'Channel Battery oreRainRate oreRainTot', '[chanm0(p),battm1(p),rainrate(p),raintotal(p)]') ,
    ('0x48', '0x2a19') : ('', '', 3, 'Channel Battery oreRainRate', '[chanm0(p),battm1(p),rainrate(p)]') ,
    ('0x54', '0x2a19') : ('', '', 3, 'Channel Battery oreRainRate oreRainTot', '[chanm0(p),battm1(p),rainrate(p),raintotal(p)]') ,
    ('0x44', '0xea4c') : ('', 'chks1(p)', 3, 'Channel Battery oreTemp', '[chanm1(p),battm1(p),temp(p)]') ,
    ('0x78', '0xea7c') : ('', 'chks1(p)', 3, 'Battery oreUV', '[battm1(p),uv1(p)]') ,
    ('0x58', '0x0a4d') : ('', 'chks2(p)', 3, 'Channel Battery oreTemp', '[chanm1(p),battm1(p),temp(p)]') ,
    ('0x54', '0x2a1d') : ('', 'chks9(p)', 3, 'Channel Battery oreRainRate oreRainTot', '[chanm0(p),battm1(p),rainrate(p),raintotal(p)]') ,
    ('0x58', '0x5a5d') : ('', 'chks5(p)', 3, 'Channel Battery oreTemp oreRH oreBP', '[chanm1(p),battm1(p),temp(p),hum(p),bar(p)]') ,
    ('0x44', '0x1a2d') : ('', '', 3, 'Channel Battery oreTemp oreRH', '[chanm1(p),battm1(p),temp(p),hum(p)]') ,
    ('0x78', '0x78ea') : ('chkside(p)', '', 2, 'Battery Current1 Current2 Current3', '[battme(p),curr1(p),curr2(p),curr3(p)]') ,
    ('0x48', '0xea4c') : ('', 'chks1(p)', 3, 'Channel Battery oreTemp', '[chanm1(p),battm1(p),temp(p)]') ,
    ('0x60', '0x5a6d') : ('', 'chks5(p)', 3, 'Channel Battery oreTemp oreRH oreBP', '[chanm1(p),battm1(p),temp(p),hum(p),bar2(p)]') ,
    ('0x58', '0x3a0d') : ('', 'chks4(p)', 3, 'Channel Battery oreWindDir oreWindSp oreWindAvSp', '[chanm0(p),battm2(p),wdir2(p),wspeed(p),wspeedavg(p)]') ,
    ('0x38', '0x1a2d') : ('', '', 3, 'Channel Battery oreTemp', '[chanm1(p),battm1(p),temp(p)]') ,
    ('0x5c', '0x06e4') : ('', 'chks8(p)', 3, 'Channel Battery oreRainRate oreRainTot', '[chanm0(p),battm1(p),rainrate(p),raintotal(p)]') ,
    ('0x48', '0x1a2d') : ('', '', 3, 'Channel Battery oreTemp', '[chanm1(p),battm1(p),temp(p)]') ,
    ('0x50', '0x1a3d') : ('', 'chks2(p)', 3, 'Channel Battery oreTemp oreRH', '[chanm1(p),battm2(p),temp(p),hum(p)]') ,
    ('0x38', '0x38') : ('', 'chksw(p)', 1, 'Channel Weight', '[chanm0(p),weight(p)]') ,
    ('0x40', '0x1a2d') : ('', '', 3, 'Channel Battery oreTemp', '[chanm1(p),battm1(p),temp(p)]') ,
    ('0x50', '0xfab8') : ('', 'chks2(p)', 3, 'Channel Battery oreTemp oreRH', '[chanm0(p),battm2(p),temp(p),hum(p)]') ,
    ('0x78', '0x1a2d') : ('', 'chks2(p)', 3, 'Channel Battery oreTemp oreRH', '[chanm1(p),battm1(p),temp(p),hum(p)]') ,
    ('0x50', '0xca2c') : ('', 'chks2(p)', 3, 'Channel Battery oreTemp oreRH', '[chanm1(p),battm1(p),temp(p),hum(p)]') ,
    ('0x50', '0x1a2d') : ('', 'chks2(p)', 3, 'Channel Battery oreTemp oreRH', '[chanm1(p),battm1(p),temp(p),hum(p)]') ,
    ('0x3c', '0x2a19') : ('', '', 3, 'Channel Battery oreRainRate', '[chanm0(p),battm1(p),rainrate(p)]') ,
    ('0x44', '0xca48') : ('', 'chks1(p)', 3, 'Channel Battery oreTemp', '[chanm1(p),battm1(p),temp(p)]') ,
    ('0x4c', '0x2a19') : ('', '', 3, 'Channel Battery oreRainRate oreRainTot', '[chanm0(p),battm1(p),rainrate(p),raintotal(p)]') ,
    ('0x58', '0x1a89') : ('', 'chks4(p)', 3, 'Channel Battery oreWindDir oreWindSp oreWindAvSp', '[chanm0(p),battm1(p),wdirno(p),wspeed(p),wspeedavg(p)]') ,
    }