from distutils.core import setup

with open('README.txt') as file:
    long_description = file.read()

setup(name='pimucHA',
      version='0.8.3',
      description='Python Integrated Multi Controllers Home Automation',
      author='Huynh Vi Lam',
      author_email='domovilam@gmail.com',
      url='http://www.pimucha.com/',
      long_description=long_description,
      packages = [
        'piHAcontrollers',
        'piHAcontrollers.ctrlfcts',
        'piHAcontrollers.devcomm',
        'piHAcontrollers.netctrls',
        'piHAcontrollers.tools',
        'piHAcore',
        'piHAcore.corelibs',
        'piHAcore.servers',
        'piHAlibs',
        'piHAparsers',
        'piHAparsers.orelibs',
        'piHAparsers.tsduolibs',
        'piHAparsers.x10libs',
        ],
      classifiers = [
        "Programming Language :: Python :: 2.6",
        "Programming Language :: Python :: 2.7",
        "Programming Language :: Python :: 3",
        "Development Status :: 4 - Beta",
        "Environment :: Console",
        "Environment :: No Input/Output (Daemon)",
        "Intended Audience :: Developers",
        "Intended Audience :: End Users/Desktop",
        "Intended Audience :: System Administrators",
        "License :: OSI Approved :: GNU General Public License v3 (GPLv3)",
        "Operating System :: OS Independent",
        "Operating System :: POSIX :: Linux",
        "Topic :: Home Automation",
        ],
      )

