# ----------------------------------------------------------------------------
#       Copyright (C) 2013-2014 Huynh Vi Lam  <domovilam@gmail.com>
#
#       This file is part of pimucha.
#
#	This program is free software: you can redistribute it and/or modify
#	it under the terms of the GNU General Public License as published by
#	the Free Software Foundation, either version 3 of the License, or
#	(at your option) any later version.
#	
#	This program is distributed in the hope that it will be useful,
#	but WITHOUT ANY WARRANTY; without even the implied warranty of
#	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#	GNU General Public License for more details.
#	
#	You should have received a copy of the GNU General Public License
#	along with this program.  If not, see <http://www.gnu.org/licenses/>.
# ----------------------------------------------------------------------------


# ----------------------------------------------------------------------------
# Use piHAcontrollers
# ----------------------------------------------------------------------------

import logging,platform,sys
from piHAlibs import (log2console,rxeventlog,rxeventq)

if sys.hexversion < 0x020700F0:
    from .piHAmopt import mainctrl
else:
    from .piHAmarg import mainctrl

logger = logging.getLogger()


args = mainctrl()
print ("Command line arguments : %s" % repr(args))

if args['debug']:
    log2console()
    logger.setLevel(logging.DEBUG)

try:
    dev = args['c_init'](args)
except ImportError as e:
    logger.debug("%s : %s", repr(e.__class__), str(e))
    sys.exit()

dev.tsetup()
if not dev.setup: sys.exit()

if args['status']:
    print ("Request Status from controller")
    data = dev.request('STAT')
    if data:
        print ("Status data from controller : %s" % repr(data))
    else:
        print ("No data from controller")
    sys.exit()

if args['log']:
    if args['evtfile']:
        evtfile = args['evtfile']
    else:
        evtfile = 'rxevents.log'
    rxeventlog(dev,logfile=evtfile)

if args['rxtcp']:
    from piHAcontrollers.tools.tcprxevt import TCPRXServer
    srv = TCPRXServer()
    srv.tsetup()
    srv.starts()
    rxeventq(dev,srv.evtnetq)

dev.close()

