# ----------------------------------------------------------------------------
#       Copyright (C) 2013-2014 Huynh Vi Lam  <domovilam@gmail.com>
#
#       This file is part of pimucha.
#
#	This program is free software: you can redistribute it and/or modify
#	it under the terms of the GNU General Public License as published by
#	the Free Software Foundation, either version 3 of the License, or
#	(at your option) any later version.
#	
#	This program is distributed in the hope that it will be useful,
#	but WITHOUT ANY WARRANTY; without even the implied warranty of
#	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#	GNU General Public License for more details.
#	
#	You should have received a copy of the GNU General Public License
#	along with this program.  If not, see <http://www.gnu.org/licenses/>.
# ----------------------------------------------------------------------------


import logging
logger = logging.getLogger()

def lst2lines(thefile):
    import os
    lines = []
    i = 0
    try:
        f = open(thefile)
    except Exception as e:
        logger.critical("%s : %s", repr(e.__class__), str(e))
        return None
    for ln in f:
        if (ln == os.linesep) or (ln == ''):
            continue
        elif ln[0] == '#':
            continue
        lines.append(ln.rstrip(os.linesep))
        if i > 100:
            break
        else:
            i += 1
    return lines
