"""

Software HEYU Team
------------------
- Website: http://www.heyu.org
- HEYU is used as base for development of scripts of piHAparsers
- Portions of piHAparsers scripts listed below have been derived from HEYU
  * piHAparsers/orelibs
  * piHAparsers/x10libs


Software AnyEvent-RFXCOM Author
-------------------------------
- Website: http://search.cpan.org/dist/AnyEvent-RFXCOM/
- AnyEvent-RFXCOM is used as base for development of scripts of piHAparsers
- Portions of piHAparsers scripts listed below have been derived from AnyEvent-RFXCOM
  * piHAparsers/orelibs
  * piHAparsers/x10libs


Software PYRFXCOM Author
------------------------
- Website: https://github.com/barnybug/pyrfxcom/
- PYRFXCOM is used as base for development of scripts of piHAparsers
- Portions of piHAparsers scripts listed below have been derived from PYRFXCOM
  * piHAparsers/orelibs
"""

# ----------------------------------------------------------------------------
# Electrisave event
#	data	'0x78 0xea 0x00 0xa6 0x42 0x00 0x00 0x00 0x16 0x9b 0xff 0x5f 0x1d 0xc0 0x54 0x08'
#	p	     '0xea 0x00 0xa6 0x42 0x00 0x00 0x00 0x16 0x9b 0xff 0x5f 0x1d 0xc0 0x54 0x08'
# ----------------------------------------------------------------------------



from .orelibs import *

# ----------------------------------------------------------------------------
# Use for Electrisave
# ----------------------------------------------------------------------------

def chkside(p):
   if (p[9] == 0xff) and (p[10] == 0x5f):
       return True
   return False




# ----------------------------------------------------------------------------
# Use for OWL 119
# ----------------------------------------------------------------------------

def chksido(p):
   if (p[0]&0xf) == 0xa:
       return True
   return False

def chkso(p):
   s = n_s(1,10,p)
   s += lo_nibble(p[11]);
   s -= (lo_nibble(p[12])<<4) + hi_nibble(p[11]);
   if s == 0:
       return True
   return False



# ----------------------------------------------------------------------------
# Use for OWL 180
# ----------------------------------------------------------------------------

def chksido1(p):
   if (p[0]&0xf) == 0x2:
       return True
   return False



# ----------------------------------------------------------------------------
# Use for OREGON bwr102
# ----------------------------------------------------------------------------

def chksw(p):
   a1 = (p[0] & 0xf0)
   a2 = (p[5] & 0xf0)
   a3 = (p[1] & 0x0f)
   a4 = (p[6] & 0x0f)
   if ( (a1 == a2) and (a3 == a4) ):
       return True
   return False




# ----------------------------------------------------------------------------
# Use for OREGON gr101
# ----------------------------------------------------------------------------

def chksidg(p):
   if p[0] & 0x0f == 3:
       return True
   return False




# ----------------------------------------------------------------------------
# Use for OREGON Sensor
# ----------------------------------------------------------------------------

def chks1(p):
    c = hi_nibble(p[6]) + (lo_nibble(p[7])<<4)
    s = ( ( nibble_sum(6, p) + lo_nibble(p[6]) - 0xa) & 0xff)
    return s == c

def chks2(p):
    return p[8] == ((nibble_sum(8, p) - 0xa) & 0xff)
    
def chks3(p):
    return p[11] == ((nibble_sum(11, p) - 0xa) & 0xff)
    
def chks4(p):
    return p[9] == ((nibble_sum(9, p) - 0xa) & 0xff)
    
def chks5(p):
    return p[10] == ((nibble_sum(10, p) - 0xa) & 0xff)
    
def chks6(p):
    return (hi_nibble(p[8])+(lo_nibble(p[9])<<4) ==
      ((nibble_sum(8, p) - 0xa) & 0xff))
      
def chks7(p):
    return p[7] == ((nibble_sum(7, p) - 0xa) & 0xff)
    
def chks8(p):
    s = ( ( nibble_sum(9, p) - 0xa) & 0xff)
    c = hi_nibble(p[9]) + (lo_nibble(p[10])<<4)
    return s == c
    
def chks9(p):
    c = ((p[8] >> 4) & 0x0f) - ((p[9] << 4) & 0xf0)
    s =  ( nibble_sum(8, p) + (p[8] & 0x0f))
    return s == c
