# ----------------------------------------------------------------------------
#       Copyright (C) 2013-2014 Huynh Vi Lam  <domovilam@gmail.com>
#
#       This file is part of pimucha.
#
#	This program is free software: you can redistribute it and/or modify
#	it under the terms of the GNU General Public License as published by
#	the Free Software Foundation, either version 3 of the License, or
#	(at your option) any later version.
#	
#	This program is distributed in the hope that it will be useful,
#	but WITHOUT ANY WARRANTY; without even the implied warranty of
#	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#	GNU General Public License for more details.
#	
#	You should have received a copy of the GNU General Public License
#	along with this program.  If not, see <http://www.gnu.org/licenses/>.
# ----------------------------------------------------------------------------

import logging
from piHAlibs import (my_fctname,coroutine)
from .parsers import ATIRParsers

logger = logging.getLogger()

def item2msgs(item):
    namedev = item[0]
    if 'ATIR' not in namedev : return None
    sdata = item[1].split()
    hd = sdata[0]
    data = sdata[1:]
    logger.debug("Data to decode %s",repr(data))
    p = [ int(i,16) for i in data ]
    logger.debug("Packet to decode %s",repr(p))
    return [namedev, hd, data, p, hd,hd,item[1]]


@my_fctname
@coroutine
def ATIRparser(decoders,rejected=None):
    """
    Parse header for ATIR
    item = [namedev,event]
    Send to next target = decoder
    """
    hdps = ATIRParsers
    while True:
        item = (yield)
        logger.debug("Event receive %s",repr(item))
        msgs = item2msgs(item)
        if not msgs : continue
        hdp = (msgs[5],msgs[4])
        if hdp not in hdps:
            if rejected: rejected.send(['NEW_PRORFX',hdp] + item)
            continue
        msgs[1] = hdps[hdp][0]
        logger.debug("%s",repr(msgs))
        for target in decoders:
            logger.debug("Data sent to %s",repr(target))
            target.send(msgs)

