# ----------------------------------------------------------------------------
#       Copyright (C) 2013-2014 Huynh Vi Lam  <domovilam@gmail.com>
#
#       This file is part of pimucha.
#
#	This program is free software: you can redistribute it and/or modify
#	it under the terms of the GNU General Public License as published by
#	the Free Software Foundation, either version 3 of the License, or
#	(at your option) any later version.
#	
#	This program is distributed in the hope that it will be useful,
#	but WITHOUT ANY WARRANTY; without even the implied warranty of
#	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#	GNU General Public License for more details.
#	
#	You should have received a copy of the GNU General Public License
#	along with this program.  If not, see <http://www.gnu.org/licenses/>.
# ----------------------------------------------------------------------------

import logging,sys,threading,time

from piHAlibs import (confgetval,lst2lines)
from .corelibs import (
    actionscriptexe,
    enable,disable,chgunit,addunit,addalias,
    )

logger = logging.getLogger()


def confscript(script):
    pscript = confgetval('pimucha.conf','FilesPath','CONFScript','confscript/')
    thefile = pscript + script.lower() + '.scr'
    lines = lst2lines(thefile)
    if not lines:
        return False
    logger.debug('Executing %s...', thefile)
    p = threading.Thread(target=actionscriptexe, args=(lines,ConfCmds))
    p.__name__ = 'ThreadCONFScript_' + 'script'
    p.daemon = True
    p.start()
    return True


ConfCmds = {
    'ADDALIAS' : addalias,
    'ADDUNIT' : addunit,
    'CHGUNIT' : chgunit,
    'ENABLE' : enable,
    'DISABLE' : disable,
    }
