# ----------------------------------------------------------------------------
#       Copyright (C) 2013-2014 Huynh Vi Lam  <domovilam@gmail.com>
#
#       This file is part of pimucha.
#
#	This program is free software: you can redistribute it and/or modify
#	it under the terms of the GNU General Public License as published by
#	the Free Software Foundation, either version 3 of the License, or
#	(at your option) any later version.
#	
#	This program is distributed in the hope that it will be useful,
#	but WITHOUT ANY WARRANTY; without even the implied warranty of
#	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#	GNU General Public License for more details.
#	
#	You should have received a copy of the GNU General Public License
#	along with this program.  If not, see <http://www.gnu.org/licenses/>.
# ----------------------------------------------------------------------------

# ----------------------------------------------------------------------------
# Use to check command
# ----------------------------------------------------------------------------

import logging,sys
logger = logging.getLogger()

CMDCheckers = {}

from .x10libs import *
CMDCheckers.update(X10Checkers)

from .tsduolibs import *
CMDCheckers.update(TSDCheckers)

try:
    from .rfxtrxlibs import *
    CMDCheckers.update(TRXCheckers)
except ImportError as e:
    print ("%s : %s" % (repr(e.__class__), str(e)))
    print ("Module RFXTRX not yet installed")


def cmdcheck(a):
    """
    Check syntax of command
    a = [protocol, houseunit, function, (level)]
    """
    args = a[1:]
    logger.debug("Checking syntax of args(hu,f,l) %s",repr(args))
    protocol = a[0].upper()
    if protocol in CMDCheckers:
        fctchk = CMDCheckers[protocol]
    else:
        logger.debug('Unknown protocol for checking syntax %s',protocol)
        return None
    logger.debug("Check with function %s",repr(fctchk))
    try:
        res = eval(fctchk)
    except Exception as e:
        logger.error("Exception / Error %s",repr(e))
        return None
    if res:
        logger.debug('Result of parsing Input : %s',repr(res))
        return [protocol] + res
    else:
        logger.debug('Failed to check HU FCT style syntax for input data %s',repr(a))
        return None
