"""

Software HEYU Team
------------------
- Website: http://www.heyu.org
- HEYU is used as base for development of scripts of piHAparsers
- Portions of piHAparsers scripts listed below have been derived from HEYU
  * piHAparsers/orelibs
  * piHAparsers/x10libs


Software AnyEvent-RFXCOM Author
-------------------------------
- Website: http://search.cpan.org/dist/AnyEvent-RFXCOM/
- AnyEvent-RFXCOM is used as base for development of scripts of piHAparsers
- Portions of piHAparsers scripts listed below have been derived from AnyEvent-RFXCOM
  * piHAparsers/orelibs
  * piHAparsers/x10libs


Software PYRFXCOM Author
------------------------
- Website: https://github.com/barnybug/pyrfxcom/
- PYRFXCOM is used as base for development of scripts of piHAparsers
- Portions of piHAparsers scripts listed below have been derived from PYRFXCOM
  * piHAparsers/orelibs

"""
# ----------------------------------------------------------------------------
# Example of Electrisave event receive from rfxcom
#	data	'0x78 0xea 0x00 0xa6 0x42 0x00 0x00 0x00 0x16 0x9b 0xff 0x5f 0x1d 0xc0 0x54 0x08'
#	p	     '0xea 0x00 0xa6 0x42 0x00 0x00 0x00 0x16 0x9b 0xff 0x5f 0x1d 0xc0 0x54 0x08'
# ----------------------------------------------------------------------------

from .orelibs import *


trxoretype = {
    '0xea4c' : '0x5002',
    '0x1a2d' : '0x5201',
    '0xfa28' : '0x5202',
    '0x2a19' : '0x5502',
    '0x2a' : '0x5a01',
    '0x62' : '0x5a02',
    }

def model2type(m):
    if m in trxoretype:
         tst = trxoretype[m]
    else:
         tst = m
    return tst[0:4], '0x' + tst[4:]


# ----------------------------------------------------------------------------
# Use for Electrisave
# ----------------------------------------------------------------------------
    
def curr1(p):
    current1 = (p[3] + ((p[4]&0x3)<<8))/10.0
    return str(current1)
    
def curr2(p):
    current2 = (((p[4]&0xfc)>>2) + ((p[5]&0xf)<<6))/10.0
    return str(current2)
    
def curr3(p):
    current3 = (((p[7]&0xf0)>>4) + ((p[6]&0x3f)<<4))/10.0
    return str(current3)

def battme(p):
    ch = 'normal'
    c = p[1] & 0x10
    if c:
        ch = 'low'
    return ch


# ----------------------------------------------------------------------------
# Use for OWL CM119
# ----------------------------------------------------------------------------

def chanmo(p):
    ch = 'N/A'
    c = p[0] & 0xf0
    if c == 0x10:
        ch = '1'
    elif c == 0x20:
        ch = '2'
    elif c == 0x30:
        ch = '3'
    return ch

def count(p):
    return str(lo_nibble(p[1]))

def pow(p):
    ipow = (lo_nibble(p[5])<<16) + (p[4]<<8) + p[3]
    return str(ipow)
    
def energy(p):
    total =(p[10] << 36) + (p[9] << 28) + (p[8] << 20) + (p[7] << 12) + (p[6] << 4) + hi_nibble(p[5])
    return (total / 223000)	 # kWh




# ----------------------------------------------------------------------------
# Use for OREGON bwr102
# ----------------------------------------------------------------------------

def weight(p):
    cweight = 1000 * (p[5] & 0x01) + 100 * ((p[4] & 0xf0) >> 4) + 10 * (p[4] & 0x0f) + ((p[3] & 0xf0) >> 4)
    cweight = cweight/10.0
    return str(cweight)




# ----------------------------------------------------------------------------
# Use for OREGON gr101
# ----------------------------------------------------------------------------

def weight1(p):
    cweight = (lo_nibble(p[4])<<12) + (p[3]<<4) + (p[2]>>4)
    cweight = cweight/400.8
    return '%.1f' % cweight




# ----------------------------------------------------------------------------
# Use for OREGON UV138
# ----------------------------------------------------------------------------
    
def uv1(p):
    uvfactor = (p[5] & 0x0f) * 10 + (p[4] >> 4);
    return str(uvfactor)




# ----------------------------------------------------------------------------
# Use for OREGON UVN800
# ----------------------------------------------------------------------------
    
def uvn(p):
    uvfactor = (p[4] >> 4);
    return str(uvfactor)






def temp(p):
    t = (((p[6]&0x8) and -1 or 1) *
        (hi_nibble(p[5])*10.0 + lo_nibble(p[5]) +
        hi_nibble(p[4])/10.0))
    return str(t)
    
def hum(p):
    h = lo_nibble(p[7])*10 + hi_nibble(p[6])
    return  str(h)

    
def bar(p):
    return 'Not implemented yet'
    
def bar2(p):
    return 'Not implemented yet'


def wdir2(p):
    return 'Not implemented yet'
    
WIND_DIRECTIONS = [ "N", "NNE", "NE", "ENE", "E", "ESE", "SE", "SSE", "S", "SSW", "SW", "WSW", "W", "WNW", "NW", "NWN" ]
def wdirno(p):
    i = hi_nibble(p[4])
    if i < len(WIND_DIRECTIONS) + 1:
        return WIND_DIRECTIONS[i]
    return 'N/A'

def wspeed(p):
    ws = lo_nibble(p[7]) * 10 + hi_nibble(p[6]) + lo_nibble(p[6]) / 10.0
    return str(ws)

def wspeedavg(p):
    wsa = hi_nibble(p[8]) * 10 + lo_nibble(p[8]) + hi_nibble(p[7]) / 10.0
    return str(wsa)


def rainrate(p):
    rain = (lo_nibble(p[6])*10 +
        hi_nibble(p[5]) + lo_nibble(p[5])/10.0 +
        hi_nibble(p[4])/100.0)
    rain *= 25.4 	# convert from inch/hr to mm/hr
    return '%.1f' % rain
    
def raintotal(p):
    train = (lo_nibble(p[9])*100 +
      dec_byte(p, 8) + dec_byte(p, 7)/100.0 +
        hi_nibble(p[6])/1000.0)
    train *= 25.4 	# convert to mm
    return '%.1f' % train


def chanm0(p):
    return 'N/A'

def chanm1(p):
    ch = 'N/A'
    c = p[2] & 0x70
    if c == 0x10:
        ch = '1'
    elif c == 0x20:
        ch = '2'
    elif c == 0x40:
        ch = '3'
    return ch

def chanm2(p):
    c = (p[2] >> 4) & 0x0f
    return str(c)


def battm0(p):
    return 'N/A'

def battm1(p):
    ch = 'normal'
    c = p[4] & 0x04
    if c:
        ch = 'low'
    return ch

def battm2(p):
    c = 10 - (p[4] & 0x0f)
    return 'level %s' % str(c)

