# ----------------------------------------------------------------------------
#       Copyright (C) 2013-2014 Huynh Vi Lam  <domovilam@gmail.com>
#
#       This file is part of pimucha.
#
#	This program is free software: you can redistribute it and/or modify
#	it under the terms of the GNU General Public License as published by
#	the Free Software Foundation, either version 3 of the License, or
#	(at your option) any later version.
#	
#	This program is distributed in the hope that it will be useful,
#	but WITHOUT ANY WARRANTY; without even the implied warranty of
#	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#	GNU General Public License for more details.
#	
#	You should have received a copy of the GNU General Public License
#	along with this program.  If not, see <http://www.gnu.org/licenses/>.
# ----------------------------------------------------------------------------


# ----------------------------------------------------------------------------
# Fonction Menu for use piHAcontrollers
# Python 2.7 and 3.x
# ----------------------------------------------------------------------------


def f_atir(args):
    import piHAcontrollers.atir as atir
    dev = atir.ATIR()
    return dev

def f_cm11(args):
    import piHAcontrollers.cm11 as cm11
    dev = cm11.CM11(args['port'])
    return dev

def f_cm15(args):
    import piHAcontrollers.cm15 as cm15
    dev = cm15.CM15()
    return dev

def f_irecv(args):
    import piHAcontrollers.irecv as irecv
    dev = irecv.IRECV()
    return dev

def f_rfxcom(args):
    import piHAcontrollers.rfxcom as rfxcom
    dev = rfxcom.RFXCOM(args['port'])
    return dev

def f_rfxtrx(args):
    import piHAcontrollers.rfxtrx as rfxtrx
    dev = rfxtrx.RFXTRX(args['port'])
    return dev

def f_tsduo(args):
    import piHAcontrollers.tsduo as tsduo
    dev = tsduo.TSDUO()
    return dev

def f_tsduo1(args):
    import piHAcontrollers.tsduo1 as tsduo1
    dev = tsduo1.TSDUO()
    return dev





def f_ftdi(args):
    try:
        import piHAcontrollers.devcomm.devftdi as ftdi
    except:
        print ('Function not yet implemented with pylibftdi')
        return None
    dev = ftdi.DEVftdi(_id=args['vidpid'])
    return dev

def f_serial(args):
    import piHAcontrollers.devcomm.devserial as serial
    dev = serial.DEVserial(args['port'])
    return dev

def f_usb(args):
    try:
        import piHAcontrollers.devcomm.devusb as usb
    except:
        print ('Python USB version 1.0 unavailable, trying version 0.4.3')
        import piHAcontrollers.devcomm.devusb0 as usb
    dev = usb.DEVusb(vid=args['vidpid'])
    return dev

