# ----------------------------------------------------------------------------
#       Copyright (C) 2013-2014 Huynh Vi Lam  <domovilam@gmail.com>
#
#       This file is part of pimucha.
#
#	This program is free software: you can redistribute it and/or modify
#	it under the terms of the GNU General Public License as published by
#	the Free Software Foundation, either version 3 of the License, or
#	(at your option) any later version.
#	
#	This program is distributed in the hope that it will be useful,
#	but WITHOUT ANY WARRANTY; without even the implied warranty of
#	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#	GNU General Public License for more details.
#	
#	You should have received a copy of the GNU General Public License
#	along with this program.  If not, see <http://www.gnu.org/licenses/>.
# ----------------------------------------------------------------------------

import logging,sys
from piHAlibs import (adstr2addr,confgetval,log2console)
from .corelibs import (mainmenu2,mainmenu3)
from .usectrl import (usecontroller,usenetcontroller,useparser)
from .startapp import (Servers,SetupDaemons,startalls,startsysf)

logger = logging.getLogger()

if sys.hexversion < 0x020700F0:
    args = mainmenu2()
else:
    args = mainmenu3()
print ("Command line arguments : %s" % repr(args))

args['ctrl'] = args['ctrl'].upper()

if args['debug']:
    log2console()
    logger.setLevel(logging.DEBUG)

startsysf(False)

RPCSAddport = confgetval('pimucha.conf','ServersArgs','RPCSAddport','')
TCPRXAddport = confgetval('pimucha.conf','ServersArgs','TCPRXAddport','')
TCPSAddport = confgetval('pimucha.conf','ServersArgs','TCPSAddport','')

if args['net']:
    startalls(False,RPCSAddport,TCPRXAddport,TCPSAddport)
    nctrl = 'N' + args['ctrl']
    dev = usenetcontroller(nctrl,adstr2addr(args['addressport']))
else:
    startalls(True,RPCSAddport,TCPRXAddport,TCPSAddport)
    dev = usecontroller(args['ctrl'],args['port'])

if dev:
    # print (repr(SetupDaemons))
    if args['eventparser']:
        useparser(args['ctrl'],dev)

