# ----------------------------------------------------------------------------
#       Copyright (C) 2013-2014 Huynh Vi Lam  <domovilam@gmail.com>
#
#       This file is part of pimucha.
#
#	This program is free software: you can redistribute it and/or modify
#	it under the terms of the GNU General Public License as published by
#	the Free Software Foundation, either version 3 of the License, or
#	(at your option) any later version.
#	
#	This program is distributed in the hope that it will be useful,
#	but WITHOUT ANY WARRANTY; without even the implied warranty of
#	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#	GNU General Public License for more details.
#	
#	You should have received a copy of the GNU General Public License
#	along with this program.  If not, see <http://www.gnu.org/licenses/>.
# ----------------------------------------------------------------------------

import logging
from piHAlibs import (my_fctname,coroutine)

logger = logging.getLogger()


def item2msgs(item):
    if not item[1].startswith('0x') : return None
    namedev = item[0]
    if 'CM11' not in namedev : return None
    data = item[1].split()
    logger.debug("Data to decode %s",repr(data))
    p = [ int(i,16) for i in data ]
    logger.debug("Packet to decode %s",repr(p))
    return [namedev, 'x10', data, p, 'NC','0x5a',item[1]]


@my_fctname
@coroutine
def CM11parser(decoders,rejected=None):
    """
    item = [namedev,events]
    split events (if several) before sending to CM11parser1
    """
    while True:
        events = (yield)
        logger.debug("Event receive %s",repr(events))
        evts = events[1].split('|')
        if len(evts) > 1:
            for event in evts:
                CM11parser1(decoders,rejected=None).send([events[0],event])
        else:
            CM11parser1(decoders,rejected=None).send(events)


@my_fctname
@coroutine
def CM11parser1(decoders,rejected=None):
    """
    item = [namedev,event]
    Send to next target = PL decoder
    """
    while True:
        item = (yield)
        logger.debug("Event receive %s",repr(item))
        msgs = item2msgs(item)
        if not msgs : continue
        namedev, protocol, data, p, model,hd,revt =  msgs
        for target in decoders:
            logger.debug("Data sent to %s",repr(target))
            target.send(msgs)
