# ----------------------------------------------------------------------------
#       Copyright (C) 2013-2014 Huynh Vi Lam  <domovilam@gmail.com>
#
#       This file is part of pimucha.
#
#	This program is free software: you can redistribute it and/or modify
#	it under the terms of the GNU General Public License as published by
#	the Free Software Foundation, either version 3 of the License, or
#	(at your option) any later version.
#	
#	This program is distributed in the hope that it will be useful,
#	but WITHOUT ANY WARRANTY; without even the implied warranty of
#	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#	GNU General Public License for more details.
#	
#	You should have received a copy of the GNU General Public License
#	along with this program.  If not, see <http://www.gnu.org/licenses/>.
# ----------------------------------------------------------------------------

import logging,sys,time
if sys.hexversion < 0x020700F0:
    from  optparse import OptionParser
else:
    import argparse

logger = logging.getLogger()

def coroutine(func):
    def start(*args,**kwargs):
        cr = func(*args,**kwargs)
        next(cr)
        return cr
    return start


@coroutine
def lineaddname(namedev,target):
    while True:
        data = (yield)
        target.send([namedev,data])


def linesend(lines,target):
    for ln in lines:
        target.send(ln)
        time.sleep(0.1)


def main2():
    parser = OptionParser(usage='usage: %prog [options] evtfile')
    parser.add_option('-c', '--controller',
                      type='choice',
                      action='store',
                      dest='controller',
                      choices=['atir', 'cm11', 'cm15', 'irecv', 'rfxcom', 'rfxtrx', 'tsduo'],
                      default='rfxcom',
                      help='Input events from controller',)
    parser.add_option('-d','--debug', default=False, action='store_true')
    parser.add_option('-o','--output', action='store')
    (options, args) = parser.parse_args()
    if len(args) != 1:
        parser.error("Error, a file name is needed...")
        sys.exit()
    rargs = vars(options)
    rargs.setdefault('evtfile')
    rargs['evtfile'] = args[0]
    return rargs

def main2e():
    parser = OptionParser(usage='usage: %prog [options] protocol houseunit function')
    parser.add_option('-d','--debug', default=False, action='store_true')
    (options, args) = parser.parse_args()
    rargs = vars(options)
    rargs.setdefault('listprotocol')
    if len(args) == 0:
        rargs['listprotocol'] = True
        return rargs
    rargs['listprotocol'] = False
    rargs.setdefault('protocol')
    rargs['protocol'] = args[0]
    rargs.setdefault('houseunit')
    rargs['houseunit'] = args[1]
    rargs.setdefault('function')
    rargs['function'] = args[2]
    return rargs



def main3():
    parser = argparse.ArgumentParser()
    parser.add_argument('evtfile',help='File name of input events to process')
    parser.add_argument('-d','--debug', default=False, action='store_true')
    parser.add_argument('-c', '--controller',
                      action='store',
                      dest='controller',
                      choices=['atir', 'cm11', 'cm15', 'irecv', 'rfxcom', 'rfxtrx', 'tsduo'],
                      default='rfxcom',
                      help='Input events from controller',)
    parser.add_argument('-o','--output', action='store')
    return vars(parser.parse_args())



def main3e():
    parser = argparse.ArgumentParser()
    parser.add_argument('-d','--debug', default=False,action='store_true')
    parser.add_argument('protocol', nargs='?', default=argparse.SUPPRESS)
    parser.add_argument('houseunit', nargs='?',default=argparse.SUPPRESS)
    parser.add_argument('function', nargs='?',default=argparse.SUPPRESS)
    parser.set_defaults(listprotocol=False)
    rargs = vars(parser.parse_args())
    if len(rargs) < 5:
        print ('Too few arguments')
        rargs['listprotocol'] = True
    return rargs
