# ----------------------------------------------------------------------------
#       Copyright (C) 2013-2014 Huynh Vi Lam  <domovilam@gmail.com>
#
#       This file is part of pimucha.
#
#	This program is free software: you can redistribute it and/or modify
#	it under the terms of the GNU General Public License as published by
#	the Free Software Foundation, either version 3 of the License, or
#	(at your option) any later version.
#	
#	This program is distributed in the hope that it will be useful,
#	but WITHOUT ANY WARRANTY; without even the implied warranty of
#	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#	GNU General Public License for more details.
#	
#	You should have received a copy of the GNU General Public License
#	along with this program.  If not, see <http://www.gnu.org/licenses/>.
# ----------------------------------------------------------------------------


# ----------------------------------------------------------------------------
# piHAcheck use for checking modules used by piHAcontrollers
# ----------------------------------------------------------------------------

import logging,sys,time
logger = logging.getLogger()
from piHAlibs import log2console

if sys.hexversion < 0x020700F0:
    from .piHAmopt import maincheck
else:
    from .piHAmarg import maincheck



def check_platform():
    import platform
    print ('Checking Install Status for Platform')
    print ('Machine : %s ' % platform.machine())
    print ('Processor : %s ' % platform.processor())
    print (platform.platform())
    if sys.platform.startswith('linux'):
        print (repr(platform.linux_distribution()))
    print ('SYS Platform : %s ' % sys.platform)
    if sys.platform.startswith('linux'):
        print ('Install ===> OK')
    else:
        print ('Install ===> Untested')
    return

def check_python():
    print ('Checking Python Version Requirement')
    if sys.hexversion >= 0x020608F0:
        print ('[OK] Python Version %s' % sys.version)
    else:
        print ('[Warning] Python Version >= 2.6.8 recommended, actual %s' % sys.version)
    return




def check_ftdi():
    print ('Checking FTDI modules')
    try:
        import pylibftdi
        print ('python pylibFTDI module present...')
    except ImportError as e:
        print ('Error in importing python pylibFTDI module...')
        logger.debug("%s : %s", repr(e.__class__), str(e))
    try:
        import ftdi1 as ftdi
        print ('python FTDI module present...')
    except ImportError as e:
        print ('Error in importing python FTDI module...')
        logger.debug("%s : %s", repr(e.__class__), str(e))
        return
    return

def check_serial():
    print ('Checking SERIAL modules')
    try:
        import serial
        print ('python Serial module present...')
    except ImportError as e:
        print ('Error in importing python Serial module...')
        logger.debug("%s : %s", repr(e.__class__), str(e))
        return
    try:
        import serial.tools.list_ports
        print ('python Serial module version >= 2.6 present...')
    except ImportError:
        print ("Version < 2.5 of PySerial do not have find port function")
        return
    return

def check_usb():
    print ('Checking USB modules')
    try:
        import piHAcontrollers.tools.usbtools as tools
        print ('python USB module version 1.0 present...')
    except ImportError as e:
        print ('Error in importing python USB module...')
        logger.debug("%s : %s", repr(e.__class__), str(e))
        return
    return 


args = maincheck()
print ("Command line arguments : %s" % repr(args))

if args['debug']:
    log2console()
    logger.setLevel(logging.DEBUG)


if args['controllers']:
    from piHAcontrollers import Controllers
    print (repr(Controllers))
    sys.exit()


if args['checkreq']:
    check_platform()
    check_python()
    sys.exit()


if args['checkmod']:
    check_ftdi()
    check_serial()
    check_usb()
    sys.exit()
