# ----------------------------------------------------------------------------
#       Copyright (C) 2013-2014 Huynh Vi Lam  <domovilam@gmail.com>
#
#       This file is part of pimucha.
#
#	This program is free software: you can redistribute it and/or modify
#	it under the terms of the GNU General Public License as published by
#	the Free Software Foundation, either version 3 of the License, or
#	(at your option) any later version.
#	
#	This program is distributed in the hope that it will be useful,
#	but WITHOUT ANY WARRANTY; without even the implied warranty of
#	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#	GNU General Public License for more details.
#	
#	You should have received a copy of the GNU General Public License
#	along with this program.  If not, see <http://www.gnu.org/licenses/>.
# ----------------------------------------------------------------------------

import logging,sys,threading
from piHAlibs import (dumprows,infothreads,checksrvs,lsdict)
from .confcmds import (confscript)
from .corelibs import (addalias,addunit,chgunit,enable,disable)
from .servers import (PortInUse,SetupControllers,SetupDaemons,TXControllers)

logger = logging.getLogger()

RPCLocalFunctions = []
RPCLocalFunctions.append((confscript,'conf'))
RPCLocalFunctions.append((addalias, 'addalias'))
RPCLocalFunctions.append((addunit, 'addunit'))
RPCLocalFunctions.append((chgunit, 'chgunit'))
RPCLocalFunctions.append((enable, 'enable'))
RPCLocalFunctions.append((disable, 'disable'))


def checktt_rpc(params):
    srvs = {
        'daemons':list(SetupDaemons),
        'ctrls':list(SetupControllers),
        'txctrls':list(TXControllers),
        }
    msg = []
    p = params.lower()
    if p in srvs:
        a = checksrvs(p,srvs[p])
        if a: msg += a
    else:
        for s in srvs:
            a = checksrvs(s,srvs[s])
            if a: msg += a
    if len(msg) == 0: return 0
    return '\n'.join(msg)
RPCLocalFunctions.append((checktt_rpc, 'check'))


def infos_rpc(params):
    if params in SetupControllers:
        return infoctrl(params)
    msg = '\tSetupControllers\n'
    msg += lsdict(SetupControllers)
    msg += '\n\tPortInUse\n'
    msg += lsdict(PortInUse)
    msg += '\n\tTXControllers\n'
    msg += lsdict(TXControllers)
    msg += '\n\tSetupDaemons\n'
    msg += lsdict(SetupDaemons)
    msg += '\n\tThreads\n'
    msg += '\n'.join(infothreads())
    return msg
RPCLocalFunctions.append((infos_rpc, 'infos'))


def stops_rpc(params):
    if params in SetupDaemons:
        SetupDaemons[params].stops()
        res = ('STOPPING %s...' % params)
        del SetupDaemons[params]
    else:
        res = 'Input error'
    return res
RPCLocalFunctions.append((stops_rpc, 'stops'))


def infoctrl(ctrl):
    dev = SetupControllers[ctrl]
    msg = ['\tDECODERS OF ' + ctrl + ' :']
    for d in dev.decodernames:
        i = dev.decodernames.index(d)
        msg.append(d + ' : ' + repr(dev.decoders[i]))
    msg.append('\tFEATURES OF ' + ctrl + ' :')
    for f in dev.featurenames:
        i = dev.featurenames.index(f)
        msg.append(f + ' : ' + repr(dev.features[i]))
    msg.append('\tDECODED FEATURES OF ' + ctrl + ' :')
    for f in dev.dfeaturenames:
        i = dev.dfeaturenames.index(f)
        msg.append(f + ' : ' + repr(dev.dfeatures[i]))
    return '\n'.join(msg)
