# ----------------------------------------------------------------------------
#       Copyright (C) 2013-2014 Huynh Vi Lam  <domovilam@gmail.com>
#
#       This file is part of pimucha.
#
#	This program is free software: you can redistribute it and/or modify
#	it under the terms of the GNU General Public License as published by
#	the Free Software Foundation, either version 3 of the License, or
#	(at your option) any later version.
#	
#	This program is distributed in the hope that it will be useful,
#	but WITHOUT ANY WARRANTY; without even the implied warranty of
#	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#	GNU General Public License for more details.
#	
#	You should have received a copy of the GNU General Public License
#	along with this program.  If not, see <http://www.gnu.org/licenses/>.
# ----------------------------------------------------------------------------

import logging,sys
from  piHAcontrollers.netctrls.netctrlibs import (NETCTRL)

logger = logging.getLogger()


def decodehex(hexseq):
    try:
        if sys.hexversion > 0x030000F0:
            a = bytes.fromhex(hexseq)
        else:
            a = hexseq.decode('hex')
        return ' '.join([ "0x%02x" % ord(y) for y in a])
    except:
        return None


class PIMUCHAD(NETCTRL):
    def __init__(self,params):
        #[name, PIMUCHADn, rxctrl, netnode, port]
        if len(params) < 5 : return None
        NETCTRL.__init__(self,rxaddr=(params[3],params[4]))
        self.name = params[0].upper()
        self.TXcap = False
        self.RXcap = True
        self.idcontroller = params[2].upper()
        self.namedev = self.name + ':' + self.idcontroller
        self.decoded_events = False

    def netsend(self,data):
        return None

    def rxchunk(self):
        received = None
        try:
            received = self.rxsock.recv(1024)
            if received:
                return received.decode("utf-8")
        except Exception as e:
            if str(e) != 'timed out':
                logger.critical("%s : %s" ,repr(e.__class__), str(e))
                self.opened == False
                self.close()
        return None


class PIMUCHAD0(PIMUCHAD):
    def rxevent(self):
        received = self.rxchunk()
        if not received: return None
        logger.debug("%s" , repr(received))
        events = []
        for evt in received.split("\n")[:-1]:
            if evt not in events:
                events.append(evt)
        if len(events) !=0 :
            return (events[-1])
        return None


class PIMUCHAD1(PIMUCHAD):
    def rxevent(self):
        received = self.rxchunk()
        if not received: return None
        logger.debug("%s" , repr(received))
        events = []
        for evt in received.split("\n")[:-1]:
            event = decodehex(evt)
            if not event: continue
            if event not in events:
                events.append(event)
        if len(events) !=0 :
            return (events[-1])
        return None


class PIMUCHAD2(PIMUCHAD):
    def rxevent(self):
        received = self.rxchunk()
        if not received: return None
        logger.debug("%s" , repr(received))
        events = []
        for evt in received.split("\n")[:-1]:
            if self.idcontroller not in evt: continue
            items = evt.split('|')
            if len(items) < 2: continue
            event = [self.namedev, decodehex(items[2])]
            if event[1] == None: continue
            if event not in events:
                events.append(event)
        if len(events) !=0 :
            return (events[-1])
        return None


class PIMUCHAD3(PIMUCHAD):
    def rxevent(self):
        received = self.rxchunk()
        if not received: return None
        logger.debug("%s" , repr(received))
        events = []
        for evt in received.split("\n")[:-1]:
            if self.idcontroller not in evt: continue
            items = evt.split('|')
            if len(items) < 3: continue
            event = [self.namedev, decodehex(items[2])]
            if event[1] == None: continue
            if event not in events:
                events.append(event)
        if len(events) !=0 :
            return (events[-1])
        return None

