# ----------------------------------------------------------------------------
#       Copyright (C) 2013-2014 Huynh Vi Lam  <domovilam@gmail.com>
#
#       This file is part of pimucha.
#
#	This program is free software: you can redistribute it and/or modify
#	it under the terms of the GNU General Public License as published by
#	the Free Software Foundation, either version 3 of the License, or
#	(at your option) any later version.
#	
#	This program is distributed in the hope that it will be useful,
#	but WITHOUT ANY WARRANTY; without even the implied warranty of
#	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#	GNU General Public License for more details.
#	
#	You should have received a copy of the GNU General Public License
#	along with this program.  If not, see <http://www.gnu.org/licenses/>.
# ----------------------------------------------------------------------------

import logging

logger = logging.getLogger()


NETControllers = {}

try:
    from .netcontrollers import NATIR
    NETControllers.update({'NATIR':NATIR})
except Exception as e:
    logger.debug("%s : %s", repr(e.__class__), str(e))

try:
    from .netcontrollers import NCM11
    NETControllers.update({'LCM11':NCM11})
    NETControllers.update({'NCM11':NCM11})
    NETControllers.update({'PCM11':NCM11})
except Exception as e:
    logger.debug("%s : %s", repr(e.__class__), str(e))

try:
    from .netcontrollers import NCM15
    NETControllers.update({'LCM15':NCM15})
    NETControllers.update({'NCM15':NCM15})
    NETControllers.update({'PCM15':NCM15})
except Exception as e:
    logger.debug("%s : %s", repr(e.__class__), str(e))

try:
    from .netcontrollers import NRFXCOM
    NETControllers.update({'NRFXCOM':NRFXCOM})
except ImportError as e:
    logger.debug("%s : %s", repr(e.__class__), str(e))

try:
    from .netcontrollers import NRFXTRX
    NETControllers.update({'LRFXTRX':NRFXTRX})
    NETControllers.update({'NRFXTRX':NRFXTRX})
    NETControllers.update({'PRFXTRX':NRFXTRX})
except ImportError as e:
    logger.debug("%s : %s", repr(e.__class__), str(e))

try:
    from .netcontrollers import NTSDUO
    NETControllers.update({'LTSDUO':NTSDUO})
    NETControllers.update({'NTSDUO':NTSDUO})
    NETControllers.update({'PTSDUO':NTSDUO})
except ImportError as e:
    logger.debug("%s : %s", repr(e.__class__), str(e))
