# ----------------------------------------------------------------------------
#       Copyright (C) 2013-2014 Huynh Vi Lam  <domovilam@gmail.com>
#
#       This file is part of pimucha.
#
#	This program is free software: you can redistribute it and/or modify
#	it under the terms of the GNU General Public License as published by
#	the Free Software Foundation, either version 3 of the License, or
#	(at your option) any later version.
#	
#	This program is distributed in the hope that it will be useful,
#	but WITHOUT ANY WARRANTY; without even the implied warranty of
#	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#	GNU General Public License for more details.
#	
#	You should have received a copy of the GNU General Public License
#	along with this program.  If not, see <http://www.gnu.org/licenses/>.
# ----------------------------------------------------------------------------

import logging,os,os.path,sys,threading,time

from piHAlibs import (actionscriptexe,coroutine,confgetval,lst2lines)
from .corelibs import (delay,shellexe,tempo,armdet,disarmdet)
from .servers import (
    INPUTq,SetupDaemons,TXControllers,
    actionsched,parsched,schedlistjobs,schedunsched)

logger = logging.getLogger()


def launchaction(action):
    if action[0] not in ActionCmds:
        logger.error("Syntax error in expression %s",action[0])
        return False
    try:
        ActionCmds[action[0]](action[1])
        logger.debug("Success in eval / execute expression %s",action[0])
        return True
    except Exception as e:
        logger.error("%s : %s", repr(e.__class__), str(e))
        logger.error("Error in eval / execute expression %s",action[0])
    return False


def chkscript(param):
    if isinstance(param,list):
        a = param[0]
    else:
        a = param
    script = a.strip().lower()
    pscript = confgetval('pimucha.conf','FilesPath','ACTIONScript','actionscript/')
    thefile = os.path.join(os.getcwd(), pscript, script + '.scr')
    if os.path.isfile(thefile): return thefile
    return None


def actionscript(p):
    if isinstance(p,list):
        param = p[0]
    else:
        param = p
    script = chkscript(param)
    if not script:
       logger.error('Script file %s not present',param)
       return False
    lines = lst2lines(script)
    if not lines:
        logger.warning('Nothing to execute, script %s empty',param)
        return False
    logger.debug('Executing %s...', script)
    p = threading.Thread(target=actionscriptexe, args=(lines,ActionCmds))
    p.__name__ = 'ThreadACTIONScript_' + param
    p.daemon = True
    p.start()
    return True


def sendto(param):
    """
    param : 4 parameters
    Namectrl Protocol HouseUnit(addressId) Function(on/off)
    """
    if isinstance(param,list):
        a = param
    else:
        a = param.split()
    namedev = a[0].upper()
    if namedev in TXControllers:
        data = ' '.join(a[1:])
        ctrl = namedev.split(':')[1]
        if ctrl[0] == 'N':
            TXControllers[namedev].netsend(data)
        else:
            INPUTq.put_nowait(data)
        return 'Send CMD to TXController %s' % namedev
    return 'No TXController with this name %s' % namedev


def schedaction(lparam):
    if 'APScheduler' in SetupDaemons:
        sched = SetupDaemons['APScheduler']
    else:
        return 'Server APScheduler not started'
    if len(lparam) == 0: return schedlistjobs(sched)
    p = parsched(lparam)
    if not p: return 'Error parsing type scheduler'
    type,actionargs,attime = p
    return actionsched(sched,type,ActionSched,actionargs,attime)


def unschedaction(lparam):
    if 'APScheduler' in SetupDaemons:
        sched = SetupDaemons['APScheduler']
    else:
        return 'Server APScheduler not started'
    if len(lparam) == 0: return schedlistjobs(sched)
    if isinstance(lparam,list):
        lparam = lparam[0]
    return schedunsched(sched,lparam)


ActionCmds = {
    'ARM' : armdet,
    'DISARM' : disarmdet,
    'INPUT' : INPUTq.put,
    'SCRIPT': actionscript,
    'SENDTO': sendto,
    'DELAY' : delay,
    'SHELL' : shellexe,
    'TEMPO' : tempo,
    'SCHED': schedaction,
    'UNSCHED': unschedaction,
    }


ActionSched = {
    'ARM' : armdet,
    'DISARM' : disarmdet,
    'INPUT' : INPUTq.put,
    'SCRIPT': actionscript,
    'SENDTO': sendto,
    }
