# ----------------------------------------------------------------------------
#       Copyright (C) 2013-2014 Huynh Vi Lam  <domovilam@gmail.com>
#
#       This file is part of pimucha.
#
#	This program is free software: you can redistribute it and/or modify
#	it under the terms of the GNU General Public License as published by
#	the Free Software Foundation, either version 3 of the License, or
#	(at your option) any later version.
#	
#	This program is distributed in the hope that it will be useful,
#	but WITHOUT ANY WARRANTY; without even the implied warranty of
#	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#	GNU General Public License for more details.
#	
#	You should have received a copy of the GNU General Public License
#	along with this program.  If not, see <http://www.gnu.org/licenses/>.
# ----------------------------------------------------------------------------

# ----------------------------------------------------------------------------
# Arm / Disarm to enable / disable detector for processing
# events received from 
# security detector like Motion sensor MS18
# Event  : data decoded
# item : ['CM0:CM15', '2013-11-11', '12:57:19','detector', 'x10s', '0x7fcc00', 'Motion_normal_MS10A']
# ----------------------------------------------------------------------------

import datetime,logging,threading
from piHAlibs import (coroutine,db2dict,lsdict,reqdb3,majdb3)
from .aliaslibs import (alias2hu,huoralias,hudevice)

logger = logging.getLogger()


DetectorsArmed = db2dict('DETECTARM'," WHERE enabled = 'True'")



def armdet(data):
    # [unitid, script, delay, dataevt]
    if isinstance(data,list):
        item = data
    else:
        item = data.split()
    if len(item) == 0: return 'Minimum one parameter (detector unit) needed\n' + lsdict(DetectorsArmed)
    script = None
    dataevt = None
    if len(item) > 1:
        script = item[1]
    if len(item) == 4: dataevt = item[3]
    if len(item) > 2:
        if item[2].isdigit():
            t = int(item[2])
            if t < 1: t = 1
            if t > 120 : t = 120
            p = threading.Timer(t * 60,unitad, [item[0],'True',script,dataevt])
            p.__name__ = 'Timer_ARMDetector_' + item[0]
            p.daemon = True
            p.start()
            return 'Detector armed with %s mn delay' % item[2]
        else:
            return 'Delay must be an integer in minuts, maximun : 120'
    return unitad(item[0],'True',script,dataevt)


def disarmdet(data):
    if isinstance(data,list):
        item = data
    else:
        item = data.split()
    if len(item) == 0: return 'One parameter (detector unit) needed\n' +  lsdict(DetectorsArmed)
    return unitad(item[0],'False')



def unitad(param,ad='True',script=None,evt=None):
    hu = huoralias(param)
    unitid = None
    if hu:
        if hu != param:
            hu = alias2hu(param)
        hu = hu.upper()
        unitid,enc = hudevice(hu,'detector')
    if unitid:
        return armdisarm([unitid,ad,script,evt])
    return 'Detector HouseUnit or Alias needed'


def armdisarm(command):
    # [detectorId,armed,script,dataevent]
    logger.debug("Command receive %s",repr(command))
    if command[0] not in DetectorsArmed: return False
    if command[1] not in ['True','False']: return False
    d = datetime.date.strftime(datetime.datetime.today(),"%Y-%m-%d %H:%M:%S")
    if DetectorsArmed[command[0]][1] != command[1]:
        DetectorsArmed[command[0]][1] = command[1]
        req1 = "UPDATE detectevent SET armed = ?, lastdtchange = ? WHERE detectorId = ?;"
        majdb3(req1,[command[1],d,command[0]])
    if command[2]:
        DetectorsArmed[command[0]][2] = command[2]
        req1 = "UPDATE detectevent SET script = ?, lastdtchange = ?  WHERE detectorId = ?;"
        majdb3(req1,[command[2],d,command[0]])
    if command[3]:
        DetectorsArmed[command[0]][3] = command[3]
        req1 = "UPDATE detectevent SET dataevent = ?, lastdtchange = ?  WHERE detectorId = ?;"
        majdb3(req1,[command[3],d,command[0]])
    logger.debug("List detectors %s",repr(DetectorsArmed))
    return lsdict(DetectorsArmed)
