# ----------------------------------------------------------------------------
#       Copyright (C) 2013-2014 Huynh Vi Lam  <domovilam@gmail.com>
#
#       This file is part of pimucha.
#
#	This program is free software: you can redistribute it and/or modify
#	it under the terms of the GNU General Public License as published by
#	the Free Software Foundation, either version 3 of the License, or
#	(at your option) any later version.
#	
#	This program is distributed in the hope that it will be useful,
#	but WITHOUT ANY WARRANTY; without even the implied warranty of
#	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#	GNU General Public License for more details.
#	
#	You should have received a copy of the GNU General Public License
#	along with this program.  If not, see <http://www.gnu.org/licenses/>.
# ----------------------------------------------------------------------------

import datetime,logging
from piHAlibs import (coroutine,db2dict,majdb3,reqdb3)

logger = logging.getLogger()


NormalState = [
    'OFF',
    'normal',
    'no_motion',
    'normal_tamper',
    'Motion_normal_MS10A',
    'Contact_normal_DS10A',
    ]

AlertState = [
    'ON',
    'alarm',
    'motion',
    'alarm_tamper',
    'Motion_alert_MS10A',
    'Contact_alert_DS10A',
    ]


def updatedetectors():
    condition = " WHERE typeunit = 'detector'"
    Detectors = db2dict('UNITS',condition)
    d = datetime.date.strftime(datetime.datetime.today(),"%Y-%m-%d %H:%M:%S").split()
    # [unitId,enabled,unit]
    for detector in Detectors:
        req = "SELECT rowId FROM detectorstate WHERE detectorId = ?;"
        row = reqdb3(req,[Detectors[detector][0],])
        if row:
            if Detectors[detector][1] == 'False':
                req1 = "DELETE FROM detectorstate WHERE rowId = ?;"
                majdb3(req1,[row[0],])
            else:
                req1 = "UPDATE detectorstate SET enabled = ?, unit = ? WHERE rowId = ?;"
                majdb3(req1,[Detectors[detector][1],Detectors[detector][2],row[0]])
        else:
            req1 = "INSERT INTO detectorstate(cdate,ctime,detectorId,enabled,unit) VALUES(?,?,?,?,?);"
            majdb3(req1,d + Detectors[detector])


# ----------------------------------------------------------------------------
# Detect state change from detector
# events received from 
# security detector like Motion sensor MS18
# Event  : data decoded
# item : ['CM0:CM15', '2013-11-11', '12:57:19','detector', 'x10s', '0x7fcc00', 'Motion_normal_MS10A']
# ----------------------------------------------------------------------------
@coroutine
def detectorstate():
    updatedetectors()
    condition = " WHERE enabled = 'True'"
    DetectorUnit = db2dict('DETECTORSTATE',condition)
    while True:
        item = (yield)
        logger.debug("Event receive %s",repr(item))
        if item[3] != 'detector': continue
        detId = item[5]
        if detId not in DetectorUnit: continue
        row = DetectorUnit[detId]	#[rowId,cstatus,cdate,ctime]
        req1 = "UPDATE detectorstate SET cdate = ?, ctime = ?, "
        V = [item[1],item[2]]
        # Update for every event
        if item[6] in NormalState:
            req1 += "lastdtnormal = ? "
        elif item[6] in AlertState:
            req1 += "lastdtalert = ? "
        else:
            req1 += "lastdtother = ? "
        V += [' '.join([item[1],item[2],item[6]])]
        if row[1] != item[6]:	#Status change
            req1 += ",cstatus = ?, pdate = ?, ptime = ?, pstatus = ? "
            V += [item[6],row[2],row[3],row[1]]
            DetectorUnit[detId] = (row[0],item[6],item[1],item[2])
        req1 += " WHERE rowId = ?;"
        V += [row[0]]
        majdb3(req1,V)
        logger.debug("Update Detectorstate with %s ",repr(V))

