# ----------------------------------------------------------------------------
#       Copyright (C) 2013-2014 Huynh Vi Lam  <domovilam@gmail.com>
#
#       This file is part of pimucha.
#
#	This program is free software: you can redistribute it and/or modify
#	it under the terms of the GNU General Public License as published by
#	the Free Software Foundation, either version 3 of the License, or
#	(at your option) any later version.
#	
#	This program is distributed in the hope that it will be useful,
#	but WITHOUT ANY WARRANTY; without even the implied warranty of
#	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#	GNU General Public License for more details.
#	
#	You should have received a copy of the GNU General Public License
#	along with this program.  If not, see <http://www.gnu.org/licenses/>.
# ----------------------------------------------------------------------------

# ----------------------------------------------------------------------------
# Launch an command or script
# by events received from 
# remote devices like IR Remote / LIRC
# remote devices like ATI Remote Wonder
# security detector like Motion sensor MS18
# Event  : data decoded
# item : ['AMCT:ATIR', '2014-02-23', '07:53:55', 'remote', 'ati', 'NC', 'KEY_STOP']
# ----------------------------------------------------------------------------
import datetime,logging
from piHAlibs import (coroutine,db2dict,log2db,majdb3)
from .actions import launchaction

logger = logging.getLogger()


@coroutine
def evtlaunch(rxctrl=None,rxdevice=None,powerkey=None):
    condition = " WHERE enabled = 'True' "
    if rxctrl:
        condition += " AND rxctrl = '" + rxctrl + "'"
    launchers = db2dict('ELAUNCHCMD',condition)
    lasts = db2dict('LAUNCHLAST',condition)
    while True:
        item = (yield)
        logger.debug("Receiving event %s ",repr(item))
        if rxctrl:
            if rxctrl not in item[0]: continue
        if rxdevice:
            if rxdevice != item[3]: continue
        evtdata = ' '.join(item[4:7])
        if powerkey:
            pk = '_'.join(item[5:7])
            if pk == powerkey:
                if len(launchers) == 0:
                    logger.debug("Resume EVTLAUNCH")
                    launchers = db2dict('ELAUNCHCMD',condition)
                else:
                    logger.debug("Suspend EVTLAUNCH")
                    launchers = {}
        if launchers == {}: continue
        if evtdata not in launchers:  continue
        action = launchers[evtdata]
        if action[3] == '': continue
        logger.debug("Row action %s associated with cmd %s",repr(action),repr(evtdata))
        data = action[4]
        if data == '': data = None
        d = datetime.date.strftime(datetime.datetime.today(),"%Y-%m-%d %H:%M:%S")
        lastime = datetime.datetime.strptime(lasts[action[0]],"%Y-%m-%d %H:%M:%S")
        t = lastime + datetime.timedelta(seconds=action[2])
        if t > datetime.datetime.today():
            logger.debug("Cmd in repeat delay %s, no action",repr(action[2]))
            continue
        if launchaction([action[3],data]):
            lasts[action[0]] = d
            req = "UPDATE launchcmd SET lastime = ? WHERE rowId = ?;"
            majdb3(req,[d, action[0]])
