# ----------------------------------------------------------------------------
#       Copyright (C) 2013-2014 Huynh Vi Lam  <domovilam@gmail.com>
#
#       This file is part of pimucha.
#
#	This program is free software: you can redistribute it and/or modify
#	it under the terms of the GNU General Public License as published by
#	the Free Software Foundation, either version 3 of the License, or
#	(at your option) any later version.
#	
#	This program is distributed in the hope that it will be useful,
#	but WITHOUT ANY WARRANTY; without even the implied warranty of
#	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#	GNU General Public License for more details.
#	
#	You should have received a copy of the GNU General Public License
#	along with this program.  If not, see <http://www.gnu.org/licenses/>.
# ----------------------------------------------------------------------------

# ----------------------------------------------------------------------------
# Launch an recorded action in launchcmd, by XMLRPC
# ----------------------------------------------------------------------------
import datetime,logging
from piHAlibs import (dumprows,log2db,majdb3,ralldb3,reqdb3)
from .actions import launchaction

logger = logging.getLogger()


def launch(param):
    req = "SELECT rowId,usename,delay,action,data,lastime FROM launchcmd "
    if param.isdigit():
        req += " WHERE rowId = ?"
    else:
        req += " WHERE usename = ?"
    V = [param,]
    action = reqdb3(req,V)
    if action:
        logger.debug("Row action %s associated with data %s",repr(action),repr(param))
    else:
        logger.error("No Launch Action with this data %s ",repr(param))
        return "No Launch Action with this data %s " % repr(param)
    if (action[3] == '') or (action[4] == ''):
        logger.error("Syntax error for row with this data %s ",repr(param))
        return "Syntax error for row with this data %s " % repr(param)
    data = action[4]
    d = datetime.date.strftime(datetime.datetime.today(),"%Y-%m-%d %H:%M:%S")
    lastime = datetime.datetime.strptime(action[5],"%Y-%m-%d %H:%M:%S")
    t = lastime + datetime.timedelta(seconds=action[2])
    if t > datetime.datetime.today():
        logger.debug("Action in repeat delay %s, no action",repr(action[2]))
        return "Action in repeat delay %s, no action" % repr(action[2])
    if launchaction([action[3],data]):
        req = "UPDATE launchcmd SET lastime = ? WHERE rowId = ?;"
        majdb3(req,[d, action[0]])
        return "Success in launch action %s associated with data %s" % (repr(action),repr(param))
    else:
        return "Failed n launch action %s associated with data %s" % (repr(action),repr(param))


def lslaunchcmd(param):
    req = 'SELECT rowId,rxdata,rxdecoded,action,data,rxctrl,usename,rxdevice FROM launchcmd'
    msg = ['List of launchcmd: ROWID | RXDATA | RXDECODED | ACTION | DATA | RXCTRL | USENAME | RXDEVICE']
    rows = ralldb3(req,'')
    if rows is None:
        return 'No LAUNCHCMD recorded in database'
    msg = dumprows(rows)
    return '\n'.join(msg)


