# ----------------------------------------------------------------------------
#       Copyright (C) 2013-2014 Huynh Vi Lam  <domovilam@gmail.com>
#
#       This file is part of pimucha.
#
#	This program is free software: you can redistribute it and/or modify
#	it under the terms of the GNU General Public License as published by
#	the Free Software Foundation, either version 3 of the License, or
#	(at your option) any later version.
#	
#	This program is distributed in the hope that it will be useful,
#	but WITHOUT ANY WARRANTY; without even the implied warranty of
#	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#	GNU General Public License for more details.
#	
#	You should have received a copy of the GNU General Public License
#	along with this program.  If not, see <http://www.gnu.org/licenses/>.
# ----------------------------------------------------------------------------

import datetime,logging,sys
from piHAlibs import (coroutine,db2dict,majdb3,ralldb3,reqdb3)

logger = logging.getLogger()

SensorEvent = db2dict('SENSOREVT'," WHERE enabled = 'True'")
#SensorLimits:[rowId,parameter,modaddrId,namelimits,limits,cv2pv,period,script,msg,applied]
#SensorEvent:[namelimits,applied,lastdtevent,lastvalue]


def applunap(order):
    # [namelimits,applied]
    logger.debug("Order receive %s",repr(order))
    if order[0] not in SensorEvent: return False
    if order[1] not in ['True','False']: return False
    if SensorEvent[order[0]][1] != order[1]:
        SensorEvent[order[0]][1] = order[1]
        req1 = "UPDATE sensorlimits SET applied = ? WHERE namelimits = ?;"
        majdb3(req1,[SensorEvent[order[0]][0],])
    logger.debug("List sensor event %s",repr(SensorEvent))
    return lsdict(SensorEvent)


def updatesensorevent():
    d = datetime.date.strftime(datetime.datetime.today(),"%Y-%m-%d %H:%M:%S")
    for event in SensorEvent:
        if not SensorEvent[event][1]: continue
        req = "SELECT max(rowId) FROM sensorevents WHERE namelimits = ?;"
        row = reqdb3(req,[SensorEvent[event][0],])
        if row[0]:
            req1 = "SELECT lastdtevent,lastvalue FROM sensorevents WHERE rowId = ?;"
            row1 = reqdb3(req1,[row[0],])
            SensorEvent[event][2] = row1[0]
            SensorEvent[event][3] = row1[1]
    return

