# ----------------------------------------------------------------------------
#       Copyright (C) 2013-2014 Huynh Vi Lam  <domovilam@gmail.com>
#
#       This file is part of pimucha.
#
#	This program is free software: you can redistribute it and/or modify
#	it under the terms of the GNU General Public License as published by
#	the Free Software Foundation, either version 3 of the License, or
#	(at your option) any later version.
#	
#	This program is distributed in the hope that it will be useful,
#	but WITHOUT ANY WARRANTY; without even the implied warranty of
#	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#	GNU General Public License for more details.
#	
#	You should have received a copy of the GNU General Public License
#	along with this program.  If not, see <http://www.gnu.org/licenses/>.
# ----------------------------------------------------------------------------


from .inputparser import *
from .syslogf import *

Servers = {'INParser':INPUTPARSER,'SYSLOGF':SYSLOGF}


try:
    from .asmtprcv import ASMTPReceiver
    Servers.update({'ASMTP':ASMTPReceiver})
except ImportError as e:
    print("%s : %s",( repr(e.__class__), str(e)))


try:
    from .rpcsrv import RPCServer
    Servers.update({'RPCS':RPCServer})
except ImportError as e:
    print("%s : %s",( repr(e.__class__), str(e)))


try:
    from .tcptxcmd import TCPTXServer
    Servers.update({'TCPS':TCPTXServer})
except ImportError as e:
    print("%s : %s",( repr(e.__class__), str(e)))


try:
    from .tcprxevt import TCPRXServer
    Servers.update({'TCPRX':TCPRXServer})
except ImportError as e:
    print("%s : %s",( repr(e.__class__), str(e)))


try:
    from .apssrv import APSServer
    Servers.update({'APScheduler':APSServer})
    from .apsfcts import *
except ImportError as e:
    print("%s : %s",( repr(e.__class__), str(e)))
