# ----------------------------------------------------------------------------
#       Copyright (C) 2013-2014 Huynh Vi Lam  <domovilam@gmail.com>
#
#       This file is part of pimucha.
#
#	This program is free software: you can redistribute it and/or modify
#	it under the terms of the GNU General Public License as published by
#	the Free Software Foundation, either version 3 of the License, or
#	(at your option) any later version.
#	
#	This program is distributed in the hope that it will be useful,
#	but WITHOUT ANY WARRANTY; without even the implied warranty of
#	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#	GNU General Public License for more details.
#	
#	You should have received a copy of the GNU General Public License
#	along with this program.  If not, see <http://www.gnu.org/licenses/>.
# ----------------------------------------------------------------------------

import datetime,logging,threading,time
from apscheduler.scheduler import Scheduler

logger = logging.getLogger()


class APSServer(Scheduler):
    def __init__(self,addr=None):
        try:
            Scheduler.__init__(self)
        except ImportError as e:
            logger.debug("%s : %s", repr(e.__class__), str(e))
            return None
        self.name = 'APScheduler'
        self.setup = False
        self.type = 'SRV'
        self.servercmds = {'STARTS':self.starts,'STOPS':self.stops}

    def tsetup(self):
        self.setup = True

    def starts(self):
        Scheduler.start(self)
        print ('APScheduler started and active...')

    def stops(self):
        self.shutdown()
        print ('APScheduler shutting down...')
