# ----------------------------------------------------------------------------
#       Copyright (C) 2013-2014 Huynh Vi Lam  <domovilam@gmail.com>
#
#       This file is part of pimucha.
#
#	This program is free software: you can redistribute it and/or modify
#	it under the terms of the GNU General Public License as published by
#	the Free Software Foundation, either version 3 of the License, or
#	(at your option) any later version.
#	
#	This program is distributed in the hope that it will be useful,
#	but WITHOUT ANY WARRANTY; without even the implied warranty of
#	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#	GNU General Public License for more details.
#	
#	You should have received a copy of the GNU General Public License
#	along with this program.  If not, see <http://www.gnu.org/licenses/>.
# ----------------------------------------------------------------------------

import logging,sys
from piHAlibs import (addreplicdb,log2console,coremenu2,coremenu3)
from .corecmds import (runscript,stopsrv)
from .coresetup import (SetupDaemons)
from .startapp import (startascript,startsysf)

logger = logging.getLogger()


def main():
    if sys.hexversion < 0x020700F0:
        args = coremenu2()
    else:
        args = coremenu3()
    logger.debug("Command line arguments : %s",repr(args))

    if args['debug']:
        log2console()
        logger.setLevel(logging.DEBUG)

    addreplicdb()

    if not startsysf(False): sys.exit()
    tt = runscript(args['startscript'],False)
    if not tt:
        stopsrv(['SYSLOGF'])
        sys.exit()
    tt.join()
    logger.debug("Successfully starting %s",args['startscript'])
    startascript()

if __name__ == '__main__':
    main()
