# ----------------------------------------------------------------------------
#       Copyright (C) 2013-2014 Huynh Vi Lam  <domovilam@gmail.com>
#
#       This file is part of pimucha.
#
#	This program is free software: you can redistribute it and/or modify
#	it under the terms of the GNU General Public License as published by
#	the Free Software Foundation, either version 3 of the License, or
#	(at your option) any later version.
#	
#	This program is distributed in the hope that it will be useful,
#	but WITHOUT ANY WARRANTY; without even the implied warranty of
#	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#	GNU General Public License for more details.
#	
#	You should have received a copy of the GNU General Public License
#	along with this program.  If not, see <http://www.gnu.org/licenses/>.
# ----------------------------------------------------------------------------

import logging

logger = logging.getLogger()


HAapps = {}

try:
    from .foscam import (FOSCAM0, FOSCAM1)
    HAapps.update({'FOSCAM0':FOSCAM0})
    HAapps.update({'FOSCAM1':FOSCAM1})
except Exception as e:
    logger.debug("%s : %s", repr(e.__class__), str(e))

try:
    from .pimuchad import (PIMUCHAD0, PIMUCHAD1, PIMUCHAD2, PIMUCHAD3)
    HAapps.update({'PIMUCHAD0':PIMUCHAD0})
    HAapps.update({'PIMUCHAD1':PIMUCHAD1})
    HAapps.update({'PIMUCHAD2':PIMUCHAD2})
    HAapps.update({'PIMUCHAD3':PIMUCHAD3})
except Exception as e:
    logger.debug("%s : %s", repr(e.__class__), str(e))

#print (repr(HAapps))