# ----------------------------------------------------------------------------
#       Copyright (C) 2013-2014 Huynh Vi Lam  <domovilam@gmail.com>
#
#       This file is part of pimucha.
#
#	This program is free software: you can redistribute it and/or modify
#	it under the terms of the GNU General Public License as published by
#	the Free Software Foundation, either version 3 of the License, or
#	(at your option) any later version.
#	
#	This program is distributed in the hope that it will be useful,
#	but WITHOUT ANY WARRANTY; without even the implied warranty of
#	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#	GNU General Public License for more details.
#	
#	You should have received a copy of the GNU General Public License
#	along with this program.  If not, see <http://www.gnu.org/licenses/>.
# ----------------------------------------------------------------------------

import datetime,logging,sys,threading,time
if sys.hexversion > 0x030000F0:
    import queue as Queue
    import urllib.request as urllib2
else:
    import Queue
    import urllib2
QEmpty = Queue.Empty

logger = logging.getLogger()


class FOSCAM(object):
    def __init__(self,params):
        #[name, FOSCAMn, camip,camport,login,pwd,refresh=300]
        if len(params) < 6 : return None
        try:
             self.interval = int(params[6])
        except:
             self.interval = 300
        self.url = "http://" + params[2] + ":" + params[3] + "/get_log.cgi?user=" + params[4] + "&pwd=" + params[5]
        self.camip =  params[2]
        self.name = params[0].upper()
        self.namedev = params[0].upper() + ':' + params[2].upper()
        self.handle = None
        self.setup = False
        self.opened = False
        self.nexttimer = None
        self.buf = ''
        self.last = datetime.datetime.today() + datetime.timedelta(seconds=-self.interval)
        self.evtq = Queue.Queue()
        self.decoded_events = True

    def tsetup(self):
        try:
            self.readcam()
            logger.debug("Camera %s is up",self.name)
            self.opened = True
            self.setup = True
        except Exception as e:
            logger.error("%s : %s", repr(e.__class__), str(e))
            logger.error("Camera %s is unavailable",self.name)
            self.close()

    def close(self):
        self.setup = False
        self.opened = False
        if self.nexttimer: self.nexttimer.cancel()
        if self.handle: self.handle.close()

    def readcam(self):
        try:
            logger.debug("Trying read camera %s",self.name)
            self.handle = urllib2.urlopen(self.url)
        except Exception as e:
            logger.error("%s : %s", repr(e.__class__), str(e))
            logger.error("Camera %s is unavailable",self.name)
            self.close()
        buf = self.handle.read().decode("utf-8")[14:-2]
        logger.debug("Data from camera %s ",repr(len(buf)))
        self.handle.close()
        self.nexttimer = None
        self.last = datetime.datetime.today() + datetime.timedelta(seconds=-self.interval)
        if len(buf) > len(self.buf):
            self.buf = buf
            self.evtq.put_nowait(buf.split("\\n"))
        else:
            logger.debug("No change since %s",datetime.datetime.strftime(self.last,"%Y-%m-%d %H:%M:%S"))

    def readtimer(self):
        tt = threading.Timer(self.interval,self.readcam)
        tt.name = 'FOSCAMTimer_' + self.name
        tt.daemon = True
        tt.start()
        self.nexttimer = tt
        next = datetime.datetime.strftime(datetime.datetime.today() + datetime.timedelta(seconds=self.interval),"%Y-%m-%d %H:%M:%S")
        logger.debug("Waiting for next read %s",next)


class FOSCAM0(FOSCAM):
    #Filter : access
    def rxevent(self):
        lines = []
        try:
            lines = self.evtq.get_nowait()
            logger.debug("Data from camera %s lines",repr(len(lines)))
        except Queue.Empty:
            return None
        event = []
        for i in range(len(lines)):
            if lines[i] == '' : continue
            if 'access' not in lines[i] : continue
            a = lines[i][5:24]
            if datetime.datetime.strptime(a,"%Y-%m-%d %H:%M:%S") > self.last:
                data = self.namedev + ' ' + a + ' detector http ' + self.camip + ' ' + lines[i][25:]
                event.append(data)
        if len(event) != 0:
            logger.debug("Data camera :\n%s",repr(event))
            return '||'.join(event)
        return None


class FOSCAM1(FOSCAM):
    #Filter : motion detect
    def rxevent(self):
        lines = []
        try:
            lines = self.evtq.get_nowait()
            logger.debug("Data from camera %s lines",repr(len(lines)))
        except Queue.Empty:
            return None
        event = []
        for i in range(len(lines)):
            if lines[i] == '' : continue
            if 'motion detect' not in lines[i] : continue
            a = lines[i][5:24]
            if datetime.datetime.strptime(a,"%Y-%m-%d %H:%M:%S") > self.last:
                data = self.namedev + ' ' + a + ' detector http ' + self.camip + ' motion detect'
                event.append(data)
        if len(event) != 0:
            logger.debug("Data camera :\n%s",repr(event))
            return '||'.join(event)
        return None

