# ----------------------------------------------------------------------------
# Use to receive RF events
# from Rfxtrx 433  transceiver
# Receiving data / USB Serial
# Python version 2.7.x and 3.x
# ----------------------------------------------------------------------------
# Company RFXCOM
# --------------
# - Website: http://www.rfxcom.com
# ----------------------------------------------------------------------------

"""
IMPORTANT:

The RFXtrx433 documentation and code files contain the Copyright message and Software License Agreement below.
Your software for the RFXtrx interface should contain the Software License Agreement.

 

Copyright 2011-2013, RFXCOM

 

ALL RIGHTS RESERVED. This document contains material protected under Netherlands Copyright Laws and Treaties and shall be subject to the exclusive jurisdiction of the Netherlands Courts. The information from this document may freely be used to create programs to exclusively interface with RFXCOM products only. Any other use or unauthorized reprint of this material is prohibited. No part of this document may be reproduced or transmitted in any form or by any means, electronic or mechanical, including photocopying, recording, or by any information storage and retrieval system without express written permission from RFXCOM.

 

//----------------------------------------------------------------------------

//                     Software License Agreement                     

//                                                                    

// Copyright 2011-2013, RFXCOM

//

// ALL RIGHTS RESERVED. This code is owned by RFXCOM, and is protected under

// Netherlands Copyright Laws and Treaties and shall be subject to the

// exclusive jurisdiction of the Netherlands Courts. The information from this

// file may freely be used to create programs to exclusively interface with

// RFXCOM products only. Any other use or unauthorized reprint of this material

// is prohibited. No part of this file may be reproduced or transmitted in

// any form or by any means, electronic or mechanical, including photocopying,

// recording, or by any information storage and retrieval system without

// express written permission from RFXCOM.

//

// The above copyright notice shall be included in all copies or substantial

// portions of this Software.

//-----------------------------------------------------------------------------

"""

import logging,time
from .devcomm.devserial import DEVserial
from .ctrlfcts.rfxtrxfct import (requestcmd,reset)

logger = logging.getLogger()


class RFXTRX(DEVserial):

    def __init__(self,port=None):
        DEVserial.__init__(self,port)
        self.idcontroller = 'RFXTRX'
        self.port = port
        self._baudrate = 38400
        self._timeout = 0.5
        self.setup = False
        self.TXcap = True
        self.RXcap = True

    def tsetup(self):
        """
        Setup interface with request status
        """
        self.open()
        if not self.opened:
            return False
        reset(self)
        self.flush()
        res = self.request('STAT')
        self.close()
        time.sleep(2)
        self.open()
        if not self.opened:
            return False
        logger.debug("Starting %s....",self.idcontroller)
        reset(self,5)
        res = self.request('STAT')
        time.sleep(2)
        res = self.request('SETM')
        if res:
            logger.debug("Status of controller %s",repr(res))
            logger.warning("%s Ready....",self.idcontroller)
            self.setup = True
            self.device = self.idcontroller + '-' + self.port

    def flush(self):
        logger.debug("Flush interface buffer by read %s...",self.idcontroller)
        n = 0
        while n < 20:
            res = self.read()
            if not res:
                 n += 1
        return True

    def ackread(self,nloop=20):
        n = 0
        data = None
        while n < nloop:
            data = self.read()
            if data in (0x0d, 0x04):
                return data
            else:
                n += 1
                time.sleep(0.1)

    def request(self,rcmd):
        return requestcmd(self,rcmd)

    def plsend(self):
        return None

    def rfsend(self,data,msgq=None,nloop=50):
        logger.debug("Send raw data %s with RFXtrx433",data)
        self.writes(data)
        hd = self.ackread(nloop)
        res = self.rxevent(hd=hd)
        if res:
            logger.debug("Successfuly send over RF %s to RFXtrx433 with response %s", data,repr(res))
            if msgq : msgq.put([self.idcontroller,'rftx',data + ':' + repr(res),'Success'])
            return True
        else:
            logger.error("Unable to send %s to RFXtrx433", data)
            if msgq : msgq.put([self.idcontroller,'rftx',data,'Fail'])
            return False

    def rxevent(self,hd=None,minlen=3,maxlen=20,nloop=10,tsleep=0.1):
        """
        Read byte / byte (in integer format) and
        return a string of sequence of hex
        """
        if not hd :
            hd = self.read()
            if not hd:
                time.sleep(tsleep)
                return None
        event = ["0x%02x" % hd]
        n = 0
        if hd > maxlen:
            logger.warning("Header read %s for the buffer greater than max lenght (%s), reject this read", hd, maxlen)
            return None
        while n < nloop:
            data = self.readh()
            if data:
                event.append(data)
                if len(event) == hd + 1:
                    break
            else:
                n += 1
                time.sleep(tsleep)
        if n > nloop:
            logger.warning("Event having number %s interrupts greater nloop %s",str(n),str(nloop))
        if len(event) < minlen:
            logger.warning("Event len %s shorter than min size (%s) for incoming event omitting this read",str(len(event)),minlen)
            return None
        return " ".join(event)
