# ----------------------------------------------------------------------------
#       Copyright (C) 2013-2014 Huynh Vi Lam  <domovilam@gmail.com>
#
#       This file is part of pimucha.
#
#	This program is free software: you can redistribute it and/or modify
#	it under the terms of the GNU General Public License as published by
#	the Free Software Foundation, either version 3 of the License, or
#	(at your option) any later version.
#	
#	This program is distributed in the hope that it will be useful,
#	but WITHOUT ANY WARRANTY; without even the implied warranty of
#	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#	GNU General Public License for more details.
#	
#	You should have received a copy of the GNU General Public License
#	along with this program.  If not, see <http://www.gnu.org/licenses/>.
# ----------------------------------------------------------------------------

import logging,os,os.path,sys,threading,time

from piHAlibs import (startscriptexe,confgetval,lst2lines,log2socket)
from .coresetup import (SetupDaemons,
    setupapp,setupctrl,setupnetctrl,setupsrv,
    startsrv,stopsrv,stopallctrls,checkdaemon,
    )
from .coremevtq import (mevtq)
from .decoders import (adddecoder,rmdecoder,addparser,rmparser)
from .rpclcmds import (RPCLocalFunctions)
from .dfeatures import (adddfeature,rmdfeature)
from .features import (addfeature,rmfeature)
from .servers import (actionsched,parsched,schedunsched)


logger = logging.getLogger()


def chkscript1(param):
    script = param.strip().lower()
    pscript = confgetval('pimucha.conf','FilesPath','STARTScript','startscript/')
    thefile = os.path.join(os.getcwd(), pscript, script + '.scr')
    if os.path.isfile(thefile): return thefile
    return None


def runscript(param,daemon=True):
    if isinstance(param,list):
        p = param[0]
    else:
        p = param
    script = chkscript1(p)
    if not script:
        logger.error('Script file %s not present',p)
        return False
    lines = lst2lines(script)
    if not lines:
        logger.warning('Nothing to execute, script %s empty',p)
        return False
    logger.debug('Executing %s...' ,script)
    p = threading.Thread(target=startscriptexe, args=(SetupDaemons['SYSLOGF'],lines,))
    p.__name__ = 'ThreadSTARTscript_' + 'p'
    p.daemon = daemon
    p.start()
    if daemon: return True
    return p
RPCLocalFunctions.append((runscript,'run'))


def schedcmd(lparam):
    if 'APScheduler' in SetupDaemons:
        sched = SetupDaemons['APScheduler']
    else:
        return 'Server APScheduler not started'
    p = parsched(lparam)
    if not p: return 'Error parsing type scheduler'
    type,cmdargs,attime = p
    return actionsched(sched,type,CmdSched,cmdargs,attime)
RPCLocalFunctions.append((schedcmd,'schedc'))


def unschedcmd(lparam):
    if 'APScheduler' in SetupDaemons:
        sched = SetupDaemons['APScheduler']
    else:
        return 'Server APScheduler not started'
    if len(lparam) == 0: return schedlistjobs(sched)
    if isinstance(lparam,list):
        lparam = lparam[0]
    return schedunsched(sched,lparam)


AdminCmds = {
    'ADDDFeature':adddfeature,
    'ADDFeature':addfeature,
    'RMDFeature':rmdfeature,
    'RMFeature':rmfeature,
    'ADDDecoder':adddecoder,
    'ADDParser':addparser,
    'MEVTQ':mevtq,
    'RMDecoder':rmdecoder,
    'RMParser':rmparser,
    'SETUPapp':setupapp,
    'SETUPctrl':setupctrl,
    'SETUPnetctrl':setupnetctrl,
    'SETUPsrv':setupsrv,
    'STARTsrv':startsrv,
    'STOPall':stopallctrls,
    'STOPsrv':stopsrv,
    'RUN':runscript,
    'SCHEDC':schedcmd,
    'UNSCHEDC':unschedcmd,
    'DEBUG':log2socket,
    }


CmdSched = {
    'CHECKDAEMON':checkdaemon,
    'RUN':runscript,
    }
