# ----------------------------------------------------------------------------
#       Copyright (C) 2013-2014 Huynh Vi Lam  <domovilam@gmail.com>
#
#       This file is part of pimucha.
#
#	This program is free software: you can redistribute it and/or modify
#	it under the terms of the GNU General Public License as published by
#	the Free Software Foundation, either version 3 of the License, or
#	(at your option) any later version.
#	
#	This program is distributed in the hope that it will be useful,
#	but WITHOUT ANY WARRANTY; without even the implied warranty of
#	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#	GNU General Public License for more details.
#	
#	You should have received a copy of the GNU General Public License
#	along with this program.  If not, see <http://www.gnu.org/licenses/>.
# ----------------------------------------------------------------------------

import datetime,logging

logger = logging.getLogger()

from piHAcore.actioncmds import ActionCmds

def launchaction(action):
    if action[0] not in ActionCmds:
        logger.error("Syntax error in expression %s",action[0])
        return False
    try:
        ActionCmds[action[0]](action[1])
        logger.debug("Success in eval / execute expression %s",action[0])
        return True
    except Exception as e:
        logger.error("%s : %s", repr(e.__class__), str(e))
        logger.error("Error in eval / execute expression %s",action[0])
    return False
