# ----------------------------------------------------------------------------
#       Copyright (C) 2013-2014 Huynh Vi Lam  <domovilam@gmail.com>
#
#       This file is part of pimucha.
#
#	This program is free software: you can redistribute it and/or modify
#	it under the terms of the GNU General Public License as published by
#	the Free Software Foundation, either version 3 of the License, or
#	(at your option) any later version.
#	
#	This program is distributed in the hope that it will be useful,
#	but WITHOUT ANY WARRANTY; without even the implied warranty of
#	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#	GNU General Public License for more details.
#	
#	You should have received a copy of the GNU General Public License
#	along with this program.  If not, see <http://www.gnu.org/licenses/>.
# ----------------------------------------------------------------------------
import datetime,logging
from piHAlibs import (
    confgetval,lst2lines,
    coroutine,log2db,log2file,printer,
    majdb3,reqdb3,
    )

logger = logging.getLogger()

def addcmd(param):
    pfile = confgetval('launchers.conf','FilesPath','CmdFilesPath','confscript/')
    lines = lst2lines(pfile + param.lower() + '.lst')
    if not lines : return False
    n = 0
    for line in lines:
        item = line.split('|')
        if len(item) < 9: 
            continue
        try:
            item[6] = int(item[6])
        except:
            item[6] = 10
        req = "SELECT rowId FROM launchcmd WHERE rxdata =? AND usename = ?"
        row = reqdb3(req,[item[2],item[5]])
        if row:
            req = "UPDATE launchcmd SET delay = ?, action= ?, data = ? WHERE rowId = ?"
            V = [item[6],item[7],item[8],row[0]]
        else:
            req = "INSERT INTO launchcmd(rxctrl,rxdevice,rxdata,rxeval,rxdecoded,usename,delay,action,data) "
            req += "VALUES(?,?,?,?,?,?,?,?,?); "
            V = item
        try:
            nb = majdb3(req,V)
            n += nb
        except:
            continue
    logger.debug('%s lines added / updated successful for %s lines input', str(n),str(len(lines)))
    return ('%s lines added / updated successful for %s lines input' % (str(n),str(len(lines))))


def delcmd(param):
    pfile = confgetval('launchers.conf','FilesPath','CmdFilesPath','confscript/')
    lines = lst2lines(pfile + param.lower() + '.lst')
    if not lines : return False
    n = 0
    for line in lines:
        item = line.split('|')
        if len(item) < 9: 
            continue
        req = "DELETE FROM launchcmd WHERE rxdata = ? AND usename = ?"
        try:
            nb = majdb3(req,[item[2],item[5]])
            n += nb
        except:
            continue
    logger.debug('%s lines deleted successful for %s lines input', str(n),str(len(lines)))
    return ('%s lines added / updated successful for %s lines input' % (str(n),str(len(lines))))


# ----------------------------------------------------------------------------
# Generate launcher commands using template
# and event received from 
# remote devices like ATI Remote
# security detector like Motion sensor MS18
# Event  : data, raw and decoded
# item = ['AMCT:ATIR', '0x14 0xed 0x28 0xf0', 'ati', 'NC', 'KEY_STOP']
# ----------------------------------------------------------------------------
@coroutine
def rawevt2cmd(template=None):
    pfile = confgetval('launchers.conf','FilesPath','CmdFilesPath','confscript/')
    tpl = '%s|remote|%s|evtdata|%s|namecmd|10|INPUT|PL A1 ON'
    v = "item[0].split(':')[1],item[1],' '.join(item[2:])"
    cmdf = 'rawevt2cmd'
    if template:
        tpl = confgetval('launchers.conf',template,'Template',tpl)
        v1 =  confgetval('launchers.conf',template,'Values',v)
        if v != v1 : 
            v = eval(v1)
        cmdf =  template.lower()
    cmdf = pfile + cmdf + '.lst'
    tl = tpl.split('|')
    if tl[3] != 'evtdata':
        fevtdata = tl[3]
    else:
        fevtdata = None
    while True:
        item = (yield)
        if fevtdata:
            evtdata = item[1]
            item[1] = eval(fevtdata)
        try:
            V = tuple(eval(v))
            res = tpl % V
            log2file(cmdf,'').send(res)
        except Exception as e:
            logger.error("Exception / Error %s",repr(e))

