# ----------------------------------------------------------------------------
#       Copyright (C) 2013-2014 Huynh Vi Lam  <domovilam@gmail.com>
#
#       This file is part of pimucha.
#
#	This program is free software: you can redistribute it and/or modify
#	it under the terms of the GNU General Public License as published by
#	the Free Software Foundation, either version 3 of the License, or
#	(at your option) any later version.
#	
#	This program is distributed in the hope that it will be useful,
#	but WITHOUT ANY WARRANTY; without even the implied warranty of
#	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#	GNU General Public License for more details.
#	
#	You should have received a copy of the GNU General Public License
#	along with this program.  If not, see <http://www.gnu.org/licenses/>.
# ----------------------------------------------------------------------------

# ----------------------------------------------------------------------------
# Arm / Disarm to enable / disable detector for processing
# events received from 
# security detector like Motion sensor MS18
# Event  : data decoded
# item : ['CM0:CM15', '2013-11-11', '12:57:19','detector', 'x10s', '0x7fcc00', 'Motion_normal_MS10A']
# ----------------------------------------------------------------------------

import datetime,logging,sys,threading
from piHAlibs import (coroutine,db2dict,lsdict,reqdb3,majdb3)
from piHAcore.corelibs import (DetectorsArmed)
from .actions import launchaction

logger = logging.getLogger()



def updatedetectevent():
    Detectors = db2dict('UNITS'," WHERE typeunit = 'detector'")
    d = datetime.date.strftime(datetime.datetime.today(),"%Y-%m-%d %H:%M:%S")
    for detector in Detectors:
        req = "SELECT rowId FROM detectevent WHERE detectorId = ?;"
        row = reqdb3(req,[Detectors[detector][0],])
        if row:
            req1 = "UPDATE detectevent SET enabled = ? WHERE rowId = ?;"
            majdb3(req1,[Detectors[detector][1],row[0]])
        else:
            try:
                req1 = "INSERT INTO detectevent(lastdtevent,detectorId,enabled) VALUES(?,?,?);"
                majdb3(req1,[d] + Detectors[detector][0:2])
            except:
                continue
    return


@coroutine
def detectevent(targets):
    updatedetectevent()
    Detectevts = db2dict('DETECTEVT')
    while True:
        item = (yield)
        logger.debug("Event receive %s",repr(item))
        if item[3] not in ('detector','device'): continue
        detId = item[5]
        if detId not in DetectorsArmed: continue
        if DetectorsArmed[detId][1] == 'False': continue
        if detId not in Detectevts: continue
        row = Detectevts[detId]
        #[rowId,detectorId,msg,dataevent,lastdtevent,tempoafter,nbhitsafter,delayprevt,nbhitsprevt,dtfirsthit]
        if DetectorsArmed[detId][3] != item[6]: continue
        #Delay post event
        d = datetime.date.strftime(datetime.datetime.today(),"%Y-%m-%d %H:%M:%S")
        lastime = datetime.datetime.strptime(row[4],"%Y-%m-%d %H:%M:%S")
        t = lastime + datetime.timedelta(seconds=row[5])
        if t > datetime.datetime.today():
            logger.debug("Event in tempo delay %s, no action",repr(t))
            row[6] += 1		#nbhitsafter
            continue
        req = "UPDATE detectevent SET lastdtevent = ?, nbhitsafter = ?, nbhitsprevt = ?  WHERE rowId = ?;"
        majdb3(req,[d,row[6],row[8],row[0]])
        script = DetectorsArmed[item[5]][2]
        item += [row[2],d,script]
        logger.debug("New event %s detected at %s",repr(item),d)
        for target in targets:
             target.send(item)
        row[4] = d
        row[6] = 0
        row[8] = 0
        launchaction(['SCRIPT',script])
