# ----------------------------------------------------------------------------
#       Copyright (C) 2013-2014 Huynh Vi Lam  <domovilam@gmail.com>
#
#       This file is part of pimucha.
#
#	This program is free software: you can redistribute it and/or modify
#	it under the terms of the GNU General Public License as published by
#	the Free Software Foundation, either version 3 of the License, or
#	(at your option) any later version.
#	
#	This program is distributed in the hope that it will be useful,
#	but WITHOUT ANY WARRANTY; without even the implied warranty of
#	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#	GNU General Public License for more details.
#	
#	You should have received a copy of the GNU General Public License
#	along with this program.  If not, see <http://www.gnu.org/licenses/>.
# ----------------------------------------------------------------------------

import datetime,logging,sys,threading
if sys.hexversion > 0x030000F0:
    import queue as Queue
else:
    import Queue
QEmpty = Queue.Empty
from piHAlibs import (coroutine,db2dict,majdb3,reqdb3)
from piHAcore.actioncmds import (
    ActionCmds,INPUTq,actionscript,
    delay,shellexe,tempo,
    )
from .detectors1 import (updatedetectevent,DetectorsArmed)

logger = logging.getLogger()


def flushdetevt(targets,hq,r):
    try:
        evt = hq.get_nowait()
        postdetevt(targets,hq,r)
    except QEmpty:
        pass
    return


# ----------------------------------------------------------------------------
# Arm / Disarm to enable / disable detector for processing
# events received from 
# security detector like Motion sensor MS18
# Event  : data decoded
# item : ['CM0:CM15', '2013-11-11', '12:57:19','detector', 'x10s', '0x7fcc00', 'Motion_normal_MS10A']
# ----------------------------------------------------------------------------
@coroutine
def detectdelay(targets):
    hq = Queue.Queue()
    updatedetectevent()
    Detectevts = db2dict('DETECTEVT')
    print (repr(Detectevts))
    while True:
        item = (yield)
        logger.debug("Event receive %s",repr(item))
        if item[3] not in ('detector','device'): continue
        detId = item[5]
        if detId not in DetectorsArmed: continue
        if DetectorsArmed[detId][1] == 'False': continue
        if detId not in Detectevts: continue
        row = Detectevts[detId]
        #[rowId,detectorId,msg,dataevent,lastdtevent,tempoafter,nbhitsafter,delayprevt,nbhitsprevt,dtfirsthit]
        if DetectorsArmed[detId][3] != item[6]: continue
        #Delay before event
        if row[7] != 0:
            if row[8] == 0:
                row[9] = datetime.date.strftime(datetime.datetime.today(),"%Y-%m-%d %H:%M:%S")
                try:
                    hq.put_nowait(item)
                except:
                    pass
                row[8] += 1
                tt = threading.Timer(row[7],postdetevt,[targets,hq,row,item])
                tt.name = 'Timer_delaydetectevent_' + detId
                tt.daemon = True
                tt.start()
                continue
            if datetime.datetime.today() - datetime.datetime.strptime(row[9],"%Y-%m-%d %H:%M:%S") < datetime.timedelta(seconds=row[7]):
                row[8] += 1
                continue
        postdetevt(targets,hq,row,item)


def postdetevt(targets,hq,row,item):
    #Delay post event
    d = datetime.date.strftime(datetime.datetime.today(),"%Y-%m-%d %H:%M:%S")
    lastime = datetime.datetime.strptime(row[4],"%Y-%m-%d %H:%M:%S")
    t = lastime + datetime.timedelta(seconds=row[5])
    if t > datetime.datetime.today():
        logger.debug("Event in tempo delay %s, no action",repr(t))
        row[6] += 1		#nbhitsafter
        return
    req = "UPDATE detectevent SET lastdtevent = ?, nbhitsafter = ?, nbhitsprevt = ?  WHERE rowId = ?;"
    majdb3(req,[d,row[6],row[8],row[0]])
    script = DetectorsArmed[item[5]][2]
    item += [row[2],d,script]
    logger.debug("New event %s detected at %s",repr(item),d)
    ActionCmds['SCRIPT'](script)
    for target in targets:
        target.send(item)
    row[4] = d
    row[6] = 0
    row[8] = 0
    return