# ----------------------------------------------------------------------------
#       Copyright (C) 2013-2014 Huynh Vi Lam  <domovilam@gmail.com>
#
#       This file is part of pimucha.
#
#	This program is free software: you can redistribute it and/or modify
#	it under the terms of the GNU General Public License as published by
#	the Free Software Foundation, either version 3 of the License, or
#	(at your option) any later version.
#	
#	This program is distributed in the hope that it will be useful,
#	but WITHOUT ANY WARRANTY; without even the implied warranty of
#	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#	GNU General Public License for more details.
#	
#	You should have received a copy of the GNU General Public License
#	along with this program.  If not, see <http://www.gnu.org/licenses/>.
# ----------------------------------------------------------------------------

# ----------------------------------------------------------------------------
# Launch an command or script
# by events received from 
# remote devices like ATI Remote Wonder
# security detector like Motion sensor MS18
# Event  : Raw data undecoded
# item : ['AMCT:ATIR','0x14 0xec 0x27 0xf0']
# ----------------------------------------------------------------------------
import datetime,logging
from piHAlibs import (coroutine,db2dict,log2db,majdb3)
from .actions import launchaction

logger = logging.getLogger()


@coroutine
def rawlaunch(rxctrl,rxdevice='',header='0x'):
    condition = " WHERE enabled = 'True' "
    condition += " AND rxctrl = '" + rxctrl + "'"
    if rxdevice == '':
        rxeval = db2dict('LAUNCHEVAL1',condition)
        rxfilter = rxctrl
    else:
        condition += " AND rxdevice = '" + rxdevice + "'"
        rxeval = db2dict('LAUNCHEVAL2',condition)
        rxfilter = (rxctrl,rxdevice)
    launchers = db2dict('RLAUNCHCMD',condition)
    lasts = db2dict('LAUNCHLAST',condition)
    while True:
        item = (yield)
        logger.debug("Receiving event %s ",repr(item))
        if rxctrl not in item[0]: continue
        if not item[1].startswith(header): continue
        evtdata = item[1]
        if rxfilter in rxeval:
            try:
                evtdata = eval(rxeval[rxfilter])
            except:
                logger.error("Error in eval of evtdata %s", repr(rxeval[rxfilter]))
        if evtdata not in launchers: continue
        action = launchers[evtdata]
        if action[3] == '': continue
        logger.debug("Row action %s associated with cmd %s",repr(action),repr(evtdata))
        data = action[4]
        if data == '': data = None
        d = datetime.date.strftime(datetime.datetime.today(),"%Y-%m-%d %H:%M:%S")
        lastime = datetime.datetime.strptime(lasts[action[0]],"%Y-%m-%d %H:%M:%S")
        t = lastime + datetime.timedelta(seconds=action[2])
        if t > datetime.datetime.today():
            logger.debug("Cmd in repeat delay %s, no action",repr(action[2]))
            continue
        if launchaction([action[3],data]):
            lasts[action[0]] = d
            req = "UPDATE launchcmd SET lastime = ? WHERE rowId = ?;"
            majdb3(req,[d, action[0]])
