# ----------------------------------------------------------------------------
#       Copyright (C) 2013-2014 Huynh Vi Lam  <domovilam@gmail.com>
#
#       This file is part of pimucha.
#
#	This program is free software: you can redistribute it and/or modify
#	it under the terms of the GNU General Public License as published by
#	the Free Software Foundation, either version 3 of the License, or
#	(at your option) any later version.
#	
#	This program is distributed in the hope that it will be useful,
#	but WITHOUT ANY WARRANTY; without even the implied warranty of
#	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#	GNU General Public License for more details.
#	
#	You should have received a copy of the GNU General Public License
#	along with this program.  If not, see <http://www.gnu.org/licenses/>.
# ----------------------------------------------------------------------------

import datetime,logging
from piHAlibs import (coroutine,db2dict,majdb3,ralldb3,reqdb3)

logger = logging.getLogger()


def initparameters():
    Parameters = db2dict('PARAMETERS')
    d = datetime.date.strftime(datetime.datetime.today(),"%Y-%m-%d %H:%M:%S").split()
    for par_id in Parameters:
        req = "SELECT rowId FROM sensorstate WHERE parameter = ? AND modaddrId = ?;"
        row = reqdb3(req,par_id)
        if row:
            if Parameters[par_id][2] == 'False':
                req1 = "DELETE FROM sensorstate WHERE rowId = ?;"
                majdb3(req1,[row[0],])
        else:
            if Parameters[par_id][2] == 'True':
                try:
                    req1 = "INSERT INTO sensorstate(cdate,ctime,parameter,modaddrId) VALUES(?,?,?,?);"
                    majdb3(req1,d + Parameters[par_id][0:2])
                except:
                    continue
    return


# ----------------------------------------------------------------------------
# Detect value change in comparison with previous value
# for a parameter from sensor events received from 
# Oregon temperature sensor
# Event  : data decoded for one parameter Temperature of the sensor
# item : ['RFX0:RFXCOM', '2013-08-01', '21:46:24', 'sensor', 'oreTemp', '0x1a2d_0x62', '30.1']
# ----------------------------------------------------------------------------
@coroutine
def sensorstate():
    initparameters()
    UnitLastValue  = db2dict('SENSORSTATE')
    UpdatedNTimes = db2dict('SENSORUNT')
    ParamEnabled = db2dict('PARAMETERS'," WHERE enabled = 'True'")
    while True:
        item = (yield)
        logger.debug("Event receive %s",repr(item))
        if item[3] != 'sensor': continue
        param = item[4]
        unit = item[5]
        if (param,unit) not in UnitLastValue: continue
        row = UnitLastValue[(param,unit)]
        #[parameter,modaddrId,rowId,cvalue,cdate,ctime]
        lastvalue = row[3]
        if lastvalue == item[6] and UpdatedNTimes[(param,unit)] < ParamEnabled[(param,unit)][3]:
            UpdatedNTimes[(param,unit)] += 1
            logger.debug("Increment for %s  UpdatedNTimes : %s",repr((param,unit)),str(UpdatedNTimes[(param,unit)]))
        else:
            V = [item[1],item[2],item[6],UpdatedNTimes[(param,unit)],row[3],row[4],row[5],row[2]]
            logger.debug("Update Sensorstate with %s ",repr(V))
            req1 = "UPDATE sensorstate set cdate = ?, ctime = ?, cvalue = ?, updatednt = ?, pvalue = ?, pdate = ?, ptime = ?  WHERE rowId = ?;"
            majdb3(req1,V)
            UpdatedNTimes[(param,unit)] = 1
            UnitLastValue[(param,unit)] = (param,unit,row[2],item[6],item[1],item[2])
