# ----------------------------------------------------------------------------
#       Copyright (C) 2013-2014 Huynh Vi Lam  <domovilam@gmail.com>
#
#       This file is part of pimucha.
#
#	This program is free software: you can redistribute it and/or modify
#	it under the terms of the GNU General Public License as published by
#	the Free Software Foundation, either version 3 of the License, or
#	(at your option) any later version.
#	
#	This program is distributed in the hope that it will be useful,
#	but WITHOUT ANY WARRANTY; without even the implied warranty of
#	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#	GNU General Public License for more details.
#	
#	You should have received a copy of the GNU General Public License
#	along with this program.  If not, see <http://www.gnu.org/licenses/>.
# ----------------------------------------------------------------------------

# ----------------------------------------------------------------------------
# Use for receive events incoming from  HAapps
# ----------------------------------------------------------------------------

import logging,sys,threading,time
if sys.hexversion > 0x030000F0:
    import queue as Queue
else:
    import Queue
QEmpty = Queue.Empty
from piHAlibs import (broadcast,splitter,splitdevt)
from piHAapps import HAapps
from .servers import (MESSAGEq,SetupDaemons,SetupControllers)


logger = logging.getLogger()


class HAAPP(object):
    """
    params = [param0,param1,param2....]
    param0 = name
    param1 = idapps
    param2 = idctrl if exist
    """
    def __init__(self,params):
        if isinstance(params,list):
            self.params = params
        else:
            self.params = params.split()            
        self.name = self.params[0]
        self.idapps = self.params[1]
        self.namedev = None
        self.stop = False
        self.setup = False
        self.timer = False
        self.featurenames = []
        self.features = []
        self.decodernames = []
        self.decoders = []
        self.dfeaturenames = []
        self.dfeatures = []
        self.servercmds = {
            'RXNOSPLIT':self.rxnosplit,
            'RXSPLIT':self.rxsplit,
            'STOPS':self.stops}
        self.initapps()

    def initapps(self):
        if self.idapps in HAapps:
            self.haapp = HAapps[self.idapps](self.params)
            if hasattr(self.haapp,'readtimer'): self.timer = True
        else:
            logger.critical("No HAapps associated with %s",self.idapps)
            self.haapp = None

    def __del__(self):
        if self.setup:
            self.haapp.close()

    def close(self):
        self.haapp.close()

    def tsetup(self):
        self.haapp.tsetup()
        self.setup = self.haapp.setup
        if self.haapp.decoded_events:
            self.dfeaturenames.append('DECODED-FEATURES')
            self.dfeatures.append(([],[]))
        if self.namedev in SetupControllers:
            del SetupControllers[self.namedev]
        SetupControllers.setdefault(self.namedev)
        SetupControllers[self.namedev] =  self
        logger.debug("Added in SetupControllers %s",repr(SetupControllers))
        SetupDaemons.setdefault(self.namedev)
        SetupDaemons[self.namedev] = self

    def cleanm(self):
        for d in self.decoders:
            d.close()
            self.decoders.remove(d)
        for d in self.decodernames:
            self.decodernames.remove(d)
        for f in self.features:
            f.close()
            self.features.remove(f)
        for f in self.featurenames:
            self.featurenames.remove(f)
        if self.namedev in SetupControllers: del SetupControllers[self.namedev]

    def dispatch(self,target):
        if not self.setup: return
        while not self.stop:
            event =  self.haapp.rxevent()
            if event:
                target.send(event)
            if self.timer:
                if not self.haapp.nexttimer:
                    self.haapp.readtimer()
            time.sleep(0.1)
        self.cleanm()

    def RXsplit(self):
        if self.haapp.decoded_events:
            self.dispatch(
                target=splitdevt(broadcast(self.dfeatures[0][1]))
                )
        else:
            self.dispatch(
                target=splitter(broadcast(self.features))
                )

    def RXnosplit(self):
        if self.haapp.decoded_events:
            self.dispatch(
                target=broadcast(self.dfeatures[0][1])
                )
        else:
            self.dispatch(
                target=broadcast(self.features)
                )

    def rxsplit(self):
        self.tt = threading.Thread(target=self.RXsplit)
        self.startt()

    def rxnosplit(self):
        self.tt = threading.Thread(target=self.RXnosplit)
        self.startt()

    def startt(self):
        self.tt.name = 'HAAPP_' + self.namedev
        self.tt.start()
        self.ttname = self.tt.name
        print('%s starting...' % self.tt.name)

    def stops(self):
        self.haapp.close()
        self.stop = True
        print('%s stopping...' % self.ttname)
