# ----------------------------------------------------------------------------
#       Copyright (C) 2013-2014 Huynh Vi Lam  <domovilam@gmail.com>
#
#       This file is part of pimucha.
#
#	This program is free software: you can redistribute it and/or modify
#	it under the terms of the GNU General Public License as published by
#	the Free Software Foundation, either version 3 of the License, or
#	(at your option) any later version.
#	
#	This program is distributed in the hope that it will be useful,
#	but WITHOUT ANY WARRANTY; without even the implied warranty of
#	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#	GNU General Public License for more details.
#	
#	You should have received a copy of the GNU General Public License
#	along with this program.  If not, see <http://www.gnu.org/licenses/>.
# ----------------------------------------------------------------------------

import  asyncore,logging,smtpd,threading
from piHAlibs import (addr2host,broadcast,log2db,printer,tstampdev)

logger = logging.getLogger()



class ASMTPReceiver(smtpd.SMTPServer):

    def __init__(self,addr=None):
        self.host,self.port = addr2host(defaddr=('localhost','1025'),addr=addr)
        smtpd.SMTPServer.__init__(self, (self.host,self.port), None)
        self.type = 'SRV'
        self.name = 'ASMTPReceiver'
        self.servercmds = {'STARTS':self.starts,'STOPS':self.stops}
        self.setup = False
        self.stop = False
        self.targets = [printer(),log2db()]
        self.relay = broadcast(self.targets)
    
    def process_message(self, peer, mailfrom, rcpttos, data):
        try:
            event = tstampdev(self.name) + ['camera', 'smtp', mailfrom, rcpttos[0]]
            self.relay.send(event)
        except Exception as e:
            logger.error("%s : %s", repr(e.__class__), str(e))
 
    def tsetup(self):
        self.setup = True

    def starts(self):
        print ('Listening at address %s on port number %s...\n' % (self.host, self.port))
        tt = threading.Thread(target=asyncore.loop)
        tt.name = 'ASMTPReceiver_' + self.name
        tt.daemon = True
        tt.start()
        print ('ASMTPReceiver started and active...')

    def stops(self):
        asyncore.close_all()
        self.stop = True
        print ('ASMTPReceiver shutting down...')

