# ----------------------------------------------------------------------------
#       Copyright (C) 2013-2014 Huynh Vi Lam  <domovilam@gmail.com>
#
#       This file is part of pimucha.
#
#	This program is free software: you can redistribute it and/or modify
#	it under the terms of the GNU General Public License as published by
#	the Free Software Foundation, either version 3 of the License, or
#	(at your option) any later version.
#	
#	This program is distributed in the hope that it will be useful,
#	but WITHOUT ANY WARRANTY; without even the implied warranty of
#	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#	GNU General Public License for more details.
#	
#	You should have received a copy of the GNU General Public License
#	along with this program.  If not, see <http://www.gnu.org/licenses/>.
# ----------------------------------------------------------------------------

import logging,sys
if sys.hexversion < 0x030000F0:
    import ConfigParser as cp
else:
    import configparser as cp

logger = logging.getLogger()


def confgetval(conffile,section,option,default):
    config = cp.RawConfigParser()
    try:
        config.read([conffile])
        val = config.get(section,option)
        if val == '' : val = default
    except:
        val = default
    return val


def confgetint(conffile,section,option,default):
    config = cp.RawConfigParser()
    try:
        config.read([conffile])
        val = config.getint(section,option)
    except:
        val = default
    return val
