# ----------------------------------------------------------------------------
#       Copyright (C) 2013-2014 Huynh Vi Lam  <domovilam@gmail.com>
#
#       This file is part of pimucha.
#
#	This program is free software: you can redistribute it and/or modify
#	it under the terms of the GNU General Public License as published by
#	the Free Software Foundation, either version 3 of the License, or
#	(at your option) any later version.
#	
#	This program is distributed in the hope that it will be useful,
#	but WITHOUT ANY WARRANTY; without even the implied warranty of
#	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#	GNU General Public License for more details.
#	
#	You should have received a copy of the GNU General Public License
#	along with this program.  If not, see <http://www.gnu.org/licenses/>.
# ----------------------------------------------------------------------------

from piHAlibs import (debug,lst2lines,log2console,log2file,printer)
from piHAfeatures import (rawevt2cmd)
from .testslibs import (linesend,lineaddname,main2,main3)
import logging,sys
logger = logging.getLogger()


if sys.hexversion < 0x020700F0:
    args = main2()
else:
    args = main3()

print ("Command line arguments : %s" % repr(args))
EVTS = []
TARGETS = [printer(),]
RAWEVT = rawevt2cmd(log2file('evtcmd',''))

if args['evtfile'] is None:
    print ("Error, a file name is needed...")
    sys.exit()
else:
    EVTS = lst2lines(args['evtfile'])
    if (EVTS is None) or (EVTS == []):
        sys.exit()

if args['debug']:
    log2console()
    logger.setLevel(logging.DEBUG)
    TARGETS.append(debug())

if args['output']:
    try:
        wf = open(args['output'],'ab')
        wf.close()
    except Exception as e:
        logger.error("%s : %s", repr(e.__class__), str(e))
        sys.exit()
    TARGETS.append(log2file(args['output']))

if args['controller'] == 'atir':
    from piHAparsers.patir import ATIRparser
    from piHAparsers.rxdevices import devdecoder
    from piHAparsers.rxremotes import rxremote
    linesend(EVTS,lineaddname('ATI0:ATIR',ATIRparser([
        devdecoder(TARGETS,printer(),newids=True,rawevt=RAWEVT),
        rxremote(TARGETS,printer(),newids=True,rawevt=RAWEVT),
       	],printer())))

if args['controller'] == 'cm11':
    from piHAparsers.pcm11 import CM11parser
    from piHAparsers.pldevices import (x10pldecoder,x10plcdecoder)
    linesend(EVTS,lineaddname('CM0:CM11',CM11parser([
        x10pldecoder(TARGETS,printer(),newids=True,rawevt=RAWEVT),
        x10plcdecoder(TARGETS,printer(),newids=True,rawevt=RAWEVT),
       	],printer())))

if args['controller'] == 'cm15':
    from piHAparsers.pcm15 import CM15parser
    from piHAparsers.pldevices import (x10pldecoder,x10plcdecoder)
    from piHAparsers.rxdetectors import detdecoder
    from piHAparsers.rxdevices import devdecoder
    from piHAparsers.rxremotes import rxremote
    linesend(EVTS,lineaddname('CM0:CM15',CM15parser([
        detdecoder(TARGETS,printer(),newids=True,rawevt=RAWEVT),
        devdecoder(TARGETS,printer(),newids=True,rawevt=RAWEVT),
        rxremote(TARGETS,printer(),newids=True,rawevt=RAWEVT),
        x10pldecoder(TARGETS,printer(),newids=True,rawevt=RAWEVT),
        x10plcdecoder(TARGETS,printer(),newids=True,rawevt=RAWEVT),
       	],printer())))

if args['controller'] == 'rfxcom':
    from piHAparsers.prfxcom import RFXCOMparser
    from piHAparsers.rxdetectors import detdecoder
    from piHAparsers.rxdevices import devdecoder
    from piHAparsers.rxremotes import rxremote
    from piHAparsers.rxsensors import oredecoder
    linesend(EVTS,lineaddname('RFX0:RFXCOM',RFXCOMparser([
        devdecoder(TARGETS,printer(),newids=True,rawevt=RAWEVT),
        oredecoder(TARGETS,printer(),newids=True),
        rxremote(TARGETS,printer(),newids=True,rawevt=RAWEVT),
        detdecoder(TARGETS,printer(),newids=True,rawevt=RAWEVT),
       	],printer())))

if args['controller'] == 'tsduo':
    from piHAparsers.ptsduo import TSDUOparser
    from piHAparsers.rxdevices import devdecoder
    from piHAparsers.rxsensors import oredecoder
    linesend(EVTS,lineaddname('TSD0:TSDUO',TSDUOparser([
        devdecoder(TARGETS,printer(),newids=True,rawevt=RAWEVT),
        oredecoder(TARGETS,printer(),newids=True),
       	],printer())))

if args['controller'] == 'rfxtrx':
    try:
        from piHAparsers.prfxtrx import RFXTRXparser
        from piHAparsers.trxdetectors import tdetdecoder
        from piHAparsers.trxdevices import tdevdecoder
        from piHAparsers.trxsensors import sensordecoder
    except:
        print ('RFXtrx modules not yet installed')
        sys.exit()
    linesend(EVTS,lineaddname('TRX0:RFXTRX',RFXTRXparser([
        tdetdecoder(TARGETS,printer(),newids=True,rawevt=RAWEVT),
        tdevdecoder(TARGETS,printer(),newids=True,rawevt=RAWEVT),
        sensordecoder(TARGETS,printer(),newids=True),
       	],printer())))


