# ----------------------------------------------------------------------------
#       Copyright (C) 2013-2014 Huynh Vi Lam  <domovilam@gmail.com>
#
#       This file is part of pimucha.
#
#	This program is free software: you can redistribute it and/or modify
#	it under the terms of the GNU General Public License as published by
#	the Free Software Foundation, either version 3 of the License, or
#	(at your option) any later version.
#	
#	This program is distributed in the hope that it will be useful,
#	but WITHOUT ANY WARRANTY; without even the implied warranty of
#	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#	GNU General Public License for more details.
#	
#	You should have received a copy of the GNU General Public License
#	along with this program.  If not, see <http://www.gnu.org/licenses/>.
# ----------------------------------------------------------------------------


# ----------------------------------------------------------------------------
# piHAdev use for discovering HA controllers
# ----------------------------------------------------------------------------

import logging,sys,time
logger = logging.getLogger()
from piHAlibs import log2console
from piHAcontrollers import (FTDIControllerIds,USBControllerIds)


if sys.hexversion < 0x020700F0:
    from .piHAmopt import maindev
else:
    from .piHAmarg import maindev


def discover_ftdi():
    print ('Discovering FTDI devices')
    try:
        import pylibftdi
        print ('python pylibFTDI module present...')
        print ('Find devices not yet implemented with this module')
    except ImportError as e:
        print ('Error in importing python pylibFTDI module...')
        logger.debug("%s : %s", repr(e.__class__), str(e))
    try:
        import ftdi1 as ftdi
        print ('python FTDI module present...')
        find_ftdi1()
    except ImportError as e:
        print ('Error in importing python FTDI module...')
        logger.debug("%s : %s", repr(e.__class__), str(e))
        return

def find_ftdi1():
    import piHAcontrollers.tools.ftditools as tools
    print ('Listing FTDI USB interface devices...')
    found = False
    for id in FTDIControllerIds:
        print ('Finding for FTDI interface: %s' % FTDIControllerIds[id])
        devs = tools.finddevice(id)
        if devs:
            found = True
            print ('Found FTDI interface: %s' % FTDIControllerIds[id])
            for dev in devs:
                print (repr(dev))
        else:
            pass
    if not found:
        print ('No FTDI HA controller or converter found on the system')
    return

def discover_serial():
    print ('Discovering SERIAL devices')
    try:
        import serial
        print ('python Serial module present...')
    except ImportError as e:
        print ('Error in importing python Serial module...')
        logger.debug("%s : %s", repr(e.__class__), str(e))
        return
    try:
        import serial.tools.list_ports
        print ('python Serial module version >= 2.6 present...')
    except ImportError:
        print ("Version < 2.5 of PySerial do not have find port function")
        return
    ports = serial.tools.list_ports.comports()
    print ('Listing SERIAL ports...')
    for p in ports:
        print ("Possible port %s :" % repr(p))
    if ports is None:
        print ('No Serial or USBSerial port found on the system')
    return 

def discover_usb():
    print ('Discovering USB devices')
    try:
        import piHAcontrollers.tools.usbtools as tools
        print ('python USB module version 1.0 present...')
    except ImportError as e:
        print ('Error in importing python USB module...')
        logger.debug("%s : %s", repr(e.__class__), str(e))
        return
    print ('Finding USB HA controllers...')
    found = False
    for id in USBControllerIds:
        dev = tools.finddevice(id)
        if dev:
            found = True
            print ('Found %s...' %  USBControllerIds[id])
        else:
            pass
    if not found:
        print ('No USB HA controller or converter found on the system')
    return 


args = maindev()
print ("Command line arguments : %s" % repr(args))

if args['debug']:
    log2console()
    logger.setLevel(logging.DEBUG)


if args['checkall']:
    discover_ftdi()
    discover_serial()
    discover_usb()
    sys.exit()


if args['verify']:
    if args['controller'] == 'ftdi':
        discover_ftdi()
    elif args['controller'] == 'serial':
        discover_serial()
    elif args['controller'] == 'usb':
        discover_usb()
    sys.exit()



if args['read']:
    try:
        dev = args['c_init'](args)
    except ImportError as e:
        logger.debug("%s : %s", repr(e.__class__), str(e))
        sys.exit()
    if not dev: sys.exit()
    dev.open()
    while dev.opened:
        data = dev.read()
        if data:
            print(repr(data))
        else:
            time.sleep(0.1)
    dev.close()

