from setuptools import setup, find_packages
import os 
from pip.req import parse_requirements

# hack for workings with pandocs
import codecs 
try: 
  codecs.lookup('mbcs') 
except LookupError: 
  ascii = codecs.lookup('ascii') 
  func = lambda name, enc=ascii: {True: enc}.get(name=='mbcs') 
  codecs.register(func) 

# install readme
readme = os.path.join(os.path.dirname(__file__), 'README.md')

try:
  import pypandoc
  long_description = pypandoc.convert(readme, 'rst')
except (IOError, ImportError):
  long_description = ""

# parse requirements file
required = [str(ir.req) for ir in parse_requirements("requirements.txt")]

# setup
setup(
  name='pinna',
  version='0.0.1',
  description='Tools for creating and listening to google alerts',
  long_description = long_description,
  classifiers=[
    "Development Status :: 3 - Alpha",
    "Intended Audience :: Developers",
    "License :: OSI Approved :: MIT License",
    "Operating System :: OS Independent",
    "Programming Language :: Python",
    ],
  keywords='',
  author='Brian Abelson',
  author_email='brian@newslynx.org',
  url='http://github.com/newslynx/pinna',
  license='MIT',
  packages=find_packages(exclude=['ez_setup', 'examples', 'tests']),
  namespace_packages=[],
  include_package_data=False,
  zip_safe=False,
  install_requires=[
    "pytz==2014.4",
    "siegfried==0.0.7"
  ],
  tests_require=[]
)