try:
    from itertools import product
except ImportError:
    # Python versions earlier than 2.6 do not include itertools.product yet
    # Use equivalent (but slower and more memory intensive) alternative
    # implementation instead
    def product(*args, **kwds):
        # product('ABCD', 'xy') --> Ax Ay Bx By Cx Cy Dx Dy
        # product(range(2), repeat=3) --> 000 001 010 011 100 101 110 111
        pools = map(tuple, args) * kwds.get('repeat', 1)
        result = [[]]
        for pool in pools:
            result = [x+[y] for x in result for y in pool]
        for prod in result:
            yield tuple(prod)
