#!/usr/bin/env python

# generated by wxGlade 0.6.3

"""
Client GUI for Playdoh. This tool allows to get idle resources on remote servers
and to allocate resources to the current client.
"""

# HACK: from playdoh import * means import playdoh package and note this module
#import sys, optparse
#del sys.path[0]

import wx, numpy, sys, optparse
from playdoh import *
from threading import Thread

# begin wxGlade: extracode
# end wxGlade




class Proxy(object):
    def __init__(self, frame):
        self.frame = frame
        self.t = None
    
    def get_server(self, text):
        msg = None
        server = str(text.strip(" \n\r"))
        l = server.split(':')
        if len(l) == 1:
            server, port = l[0], str(DEFAULT_PORT)
        elif len(l) == 2:
            server, port = l[0], l[1]
        else:
            msg = "server IP must be 'IP:port'"
            log_warn(msg)
        server = server.strip()
        port = int(port.strip())
        return (server, port)

    def _get_resources(self, server):
#        try:
        GC.set([server])
        disconnect = GC.connect()
        if not numpy.array(GC.connected).all(): pass# raise Exception()
        available_resources = get_available_resources([server])[0]
        my_resources = get_my_resources([server])[0]
        if disconnect: GC.disconnect()
#        except:
#            log_debug("Connection error")
#            idle_resources, my_resources = None, None
        resources = available_resources, my_resources
        self.frame.update_info(resources)
    
    def get_resources(self, server):
        if self.t is not None: self.t.join()
        t = Thread(target=self._get_resources, args=(server,))
        t.start()
        self.t = t

    def get_info(self, server, idle_resources, my_resources):
        text = "Resources allocated on %s, port %d\n" % server
        for unit_type in ['CPU', 'GPU']:
            text += "%d %s(s) idle, including %d allocated to you\n" % (idle_resources[unit_type],
                                                                        unit_type,
                                                                        my_resources[unit_type])
        return text

    def _request_resources(self, server, cpu, gpu):
        try:
            GC.set([server])
            disconnect = GC.connect()
            request_resources([server], CPU=cpu, GPU=gpu)
            self._get_resources(server)
            if disconnect: GC.disconnect()
        except:
            log_warn("Connection error")
    
    def request_resources(self, server, cpu, gpu):
        if self.t is not None: self.t.join()
        t = Thread(target=self._request_resources, args=(server, cpu, gpu))
        t.start()
        self.t = t

    def exit(self):
        if self.t is not None: self.t.join()
        GC.disconnect()



class MyFrame(wx.Frame):
    def __init__(self, *args, **kwds):
        # begin wxGlade: MyFrame.__init__
        kwds["style"] = wx.DEFAULT_FRAME_STYLE
        wx.Frame.__init__(self, *args, **kwds)
        self.combo_box = wx.ComboBox(self, -1, choices=USERPREF['favoriteservers'], style=wx.CB_DROPDOWN|wx.CB_DROPDOWN)
        self.button_get_info = wx.Button(self, -1, "Get info")
        self.text_info = wx.TextCtrl(self, -1, "", style=wx.TE_MULTILINE|wx.TE_READONLY|wx.TE_LINEWRAP)
        self.text_cpu = wx.TextCtrl(self, -1, "0 CPU(s)")
        self.slider_cpu = wx.Slider(self, -1, 0, 0, 0, style=wx.SL_HORIZONTAL|wx.SL_AUTOTICKS)
        self.text_gpu = wx.TextCtrl(self, -1, "0 GPU(s)")
        self.slider_gpu = wx.Slider(self, -1, 0, 0, 0, style=wx.SL_HORIZONTAL|wx.SL_AUTOTICKS)
        self.button_allocate = wx.Button(self, -1, "Allocate")
        self.button_exit = wx.Button(self, -1, "Exit")

        self.__set_properties()
        self.__do_layout()

        self.Bind(wx.EVT_BUTTON, self.event_get_info, self.button_get_info)
        self.Bind(wx.EVT_COMMAND_SCROLL, self.event_scroll_cpu, self.slider_cpu)
        self.Bind(wx.EVT_COMMAND_SCROLL, self.event_scroll_gpu, self.slider_gpu)
        self.Bind(wx.EVT_BUTTON, self.event_allocate, self.button_allocate)
        self.Bind(wx.EVT_BUTTON, self.event_exit, self.button_exit)
        # end wxGlade
        
        self.proxy = Proxy(self)
        self.servers = USERPREF['favoriteservers']
        self.server = None
        self.resources = None

    def __set_properties(self):
        # begin wxGlade: MyFrame.__set_properties
        self.SetTitle("Playdoh Client GUI")
        self.SetSize((380, 350))
        self.combo_box.SetSelection(0)
        self.text_cpu.Enable(False)
        self.text_gpu.Enable(False)
        # end wxGlade

    def __do_layout(self):
        # begin wxGlade: MyFrame.__do_layout
        sizer_3 = wx.BoxSizer(wx.VERTICAL)
        sizer_6 = wx.BoxSizer(wx.HORIZONTAL)
        sizer_5 = wx.BoxSizer(wx.HORIZONTAL)
        sizer_4 = wx.BoxSizer(wx.HORIZONTAL)
        sizer_3.Add(self.combo_box, 0, wx.EXPAND, 0)
        sizer_4.Add(self.button_get_info, 1, wx.EXPAND, 0)
        sizer_3.Add(sizer_4, 1, wx.EXPAND, 0)
        sizer_3.Add(self.text_info, 4, wx.EXPAND, 0)
        sizer_5.Add(self.text_cpu, 1, wx.EXPAND, 0)
        sizer_5.Add(self.slider_cpu, 2, wx.EXPAND, 0)
        sizer_5.Add(self.text_gpu, 1, wx.EXPAND, 0)
        sizer_5.Add(self.slider_gpu, 2, wx.EXPAND, 0)
        sizer_3.Add(sizer_5, 1, wx.EXPAND, 0)
        sizer_6.Add(self.button_allocate, 1, wx.EXPAND, 0)
        sizer_6.Add(self.button_exit, 1, wx.EXPAND, 0)
        sizer_3.Add(sizer_6, 1, wx.EXPAND, 0)
        self.SetSizer(sizer_3)
        self.Layout()
        # end wxGlade

    def enable(self):
        self.button_get_info.Enable()
        self.button_allocate.Enable()
        self.slider_cpu.Enable()
        self.slider_gpu.Enable()
        
    def disable(self):
        self.button_get_info.Disable()
        self.button_allocate.Disable()
        self.slider_cpu.Disable()
        self.slider_gpu.Disable()

    def update_info(self, resources):
        self.idle_resources, self.my_resources = resources
        
        self.enable()
        
        if self.idle_resources is None and self.my_resources is None:
            return
        
        # set text info
        text = self.proxy.get_info(self.server, self.idle_resources, self.my_resources)
        self.text_info.Clear()
        self.text_info.AppendText(text)
        
        maxcpu = self.idle_resources['CPU']
        cpu = self.my_resources['CPU']
#        if cpu == 0: cpu = maxcpu
        
        maxgpu = self.idle_resources['GPU']
        gpu = self.my_resources['GPU']
#        if gpu == 0: gpu = maxgpu
        
        self.slider_cpu.SetMax(maxcpu)
        self.slider_cpu.SetValue(cpu)
        self.text_cpu.Clear()
        self.text_cpu.AppendText("%d CPU(s)" % self.slider_cpu.GetValue())
        
        self.slider_gpu.SetMax(maxgpu)
        self.slider_gpu.SetValue(gpu)
        self.text_gpu.Clear()
        self.text_gpu.AppendText("%d GPU(s)" % self.slider_gpu.GetValue())
        
    def event_get_info(self, event): # wxGlade: MyFrame.<event_handler>
        server = self.combo_box.GetValue()
        if server not in self.servers:
            self.servers.append(str(server))
            USERPREF['favoriteservers'] = self.servers
            USERPREF.save()
        
        self.server = self.proxy.get_server(server)
        self.proxy.get_resources(self.server)
        
        self.disable()

    def event_stop(self, event): # wxGlade: MyFrame.<event_handler>
        print "Event handler `event_stop' not implemented"
        event.Skip()

    def event_scroll_cpu(self, event): # wxGlade: MyFrame.<event_handler>
        self.text_cpu.Clear()
        self.text_cpu.AppendText("%d CPU(s)" % self.slider_cpu.GetValue())

    def event_scroll_gpu(self, event): # wxGlade: MyFrame.<event_handler>
        self.text_gpu.Clear()
        self.text_gpu.AppendText("%d GPU(s)" % self.slider_gpu.GetValue())

    def event_allocate(self, event): # wxGlade: MyFrame.<event_handler>
        cpu = self.slider_cpu.GetValue()
        gpu = self.slider_gpu.GetValue()
        self.proxy.request_resources(self.server, cpu, gpu)

    def event_exit(self, event): # wxGlade: MyFrame.<event_handler>
        self.Close(True)

# end of class MyFrame

def gui():
    app = wx.PySimpleApp(0)
    wx.InitAllImageHandlers()
    frame_1 = MyFrame(None, -1, "")
    app.SetTopWindow(frame_1)
    frame_1.Show()
    app.MainLoop()
    
if __name__ == "__main__":
    gui()
